/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18n {
    private static Logger log = LoggerFactory.getLogger(I18n.class);
    private static final String BUNDLE_NAME = "org.eclipse.jubula.tools.internal.i18n.jubulaI18n";
    private static ResourceBundle resourceBundle = null;

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            log.error("Cannot find I18N-resource bundle!");
        }
    }

    private I18n() {
    }

    public static String getString(String key) {
        return I18n.getString(key, true);
    }

    public static String getString(String key, boolean fallBack) {
        String str;
        block4: {
            if (key == null) {
                return "";
            }
            if ("".equals(key)) {
                return key;
            }
            str = "";
            try {
                str = resourceBundle.getString(key);
            }
            catch (MissingResourceException mre) {
                CompSystemI18n.logError(key, mre);
                if (!fallBack) break block4;
                return key;
            }
        }
        return str;
    }

    public static String getStringWithoutErrorReport(String key, boolean fallBack) {
        String str;
        block4: {
            if (key == null) {
                return "";
            }
            if ("".equals(key)) {
                return key;
            }
            str = "";
            try {
                str = resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                if (!fallBack) break block4;
                return key;
            }
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public static String getString(String key, Object[] args) {
        if ("".equals(key)) {
            return key;
        }
        try {
            formatter = new MessageFormat(I18n.resourceBundle.getString(key));
            return formatter.format(args);
        }
        catch (MissingResourceException e) {
            I18n.log.error(e.toString());
            buf = new StringBuffer(key);
            i = 0;
            ** while (args != null && i < args.length)
        }
lbl-1000:
        // 1 sources

        {
            if (args[i] != null) {
                buf.append(" ");
                buf.append(args[i]);
            }
            ++i;
            continue;
        }
lbl18:
        // 1 sources

        return buf.toString();
    }

    public static String getStringWithoutErrorReport(String key, Object[] args) {
        if ("".equals(key)) {
            return key;
        }
        try {
            MessageFormat formatter = new MessageFormat(resourceBundle.getString(key));
            try {
                return formatter.format(args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return key;
            }
        }
        catch (MissingResourceException missingResourceException) {
            MessageFormat formatter = new MessageFormat(key);
            return formatter.format(args);
        }
    }
}

