/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.m2eclipse;

import java.util.Arrays;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.groovy.m2eclipse.ProjectSourceType;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.internal.AbstractJavaProjectConfigurator;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GroovyProjectConfigurator
extends AbstractJavaProjectConfigurator
implements IJavaProjectConfigurator {
    private static final String GROOVY_NATURE = "org.eclipse.jdt.groovy.core.groovyNature";
    private static final IPath DSLD_CONTAINER_ID = new Path("GROOVY_DSL_SUPPORT");

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.configure(request, monitor);
        ProjectSourceType sourceType = ProjectSourceType.getSourceType(request.getMavenProjectFacade());
        if (sourceType != null) {
            GroovyProjectConfigurator.addNature((IProject)request.getProject(), (String)GROOVY_NATURE, (IProgressMonitor)monitor);
        } else {
            IProjectDescription description = request.getProject().getDescription();
            if (description.hasNature(GROOVY_NATURE)) {
                description.setNatureIds((String[])Arrays.stream(description.getNatureIds()).filter(n -> !n.equals(GROOVY_NATURE)).toArray(String[]::new));
                request.getProject().setDescription(description, null);
            }
        }
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) {
        ProjectSourceType sourceType = ProjectSourceType.getSourceType(request.getMavenProjectFacade());
        if (sourceType != null) {
            IFolder srcTestGroovy;
            if (GroovyProjectConfigurator.isAbsent(classpath, DSLD_CONTAINER_ID) && GroovyProjectConfigurator.isAddDslSupport()) {
                classpath.addEntry(JavaCore.newContainerEntry((IPath)DSLD_CONTAINER_ID, null, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"maven.pomderived", (String)"true")}, (boolean)false));
            }
            IProject project = request.getProject();
            IPath mainOutput = this.getFolder(project, request.getMavenProject().getBuild().getOutputDirectory()).getFullPath();
            IPath testOutput = this.getFolder(project, request.getMavenProject().getBuild().getTestOutputDirectory()).getFullPath();
            IFolder srcMainGroovy = project.getFolder("src/main/groovy");
            if (srcMainGroovy.exists() && (sourceType == ProjectSourceType.MAIN || sourceType == ProjectSourceType.BOTH) && GroovyProjectConfigurator.isAbsent(classpath, srcMainGroovy.getFullPath())) {
                classpath.addSourceEntry(srcMainGroovy.getFullPath(), mainOutput, true);
            }
            if ((srcTestGroovy = project.getFolder("src/test/groovy")).exists() && (sourceType == ProjectSourceType.TEST || sourceType == ProjectSourceType.BOTH) && GroovyProjectConfigurator.isAbsent(classpath, srcTestGroovy.getFullPath())) {
                classpath.addSourceEntry(srcTestGroovy.getFullPath(), testOutput, true).setClasspathAttribute("test", "true");
            }
            classpath.removeEntry(project.getFullPath().append("target/generated-sources/groovy-stubs/main"));
        }
    }

    protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        String configScript = null;
        for (MojoExecution me : this.getCompilerMojoExecutions(request, monitor)) {
            String[] tokens;
            Map m = (Map)this.maven.getMojoParameterValue(request.getMavenProject(), me, "compilerArguments", Map.class, monitor);
            if (m != null && m.get("configScript") != null) {
                configScript = ((String)m.get("configScript")).trim();
                continue;
            }
            String s = (String)this.maven.getMojoParameterValue(request.getMavenProject(), me, "compilerArgument", String.class, monitor);
            if (s == null || !s.contains("configScript") || (tokens = s.split("=")).length != 2 || !tokens[0].trim().matches("-?configScript")) continue;
            configScript = tokens[1].trim();
        }
        options.put("org.eclipse.jdt.core.compiler.groovy.groovyCompilerConfigScript", configScript);
        super.addJavaProjectOptions(options, request, monitor);
    }

    protected static boolean isAbsent(IClasspathDescriptor classpath, IPath path) {
        if (classpath.containsPath(path)) {
            classpath.touchEntry(path);
            return false;
        }
        return true;
    }

    protected static boolean isAddDslSupport() {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.codehaus.groovy.eclipse.dsl");
        boolean value = prefs.getBoolean("org.codehaus.groovy.eclipse.dsl.auto.add.support");
        return value;
    }
}

