/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist.proposals;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal2;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToMultiLineStringProposal
extends GroovyQuickAssistProposal2 {
    private List<Expression> expressions;
    private String lineDelimiter;

    @Override
    public String getDisplayString() {
        return "Convert to multi-line string";
    }

    @Override
    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    @Override
    public int getRelevance() {
        if (this.expressions == null) {
            this.expressions = Collections.emptyList();
            ASTNode node = this.context.getCoveredNode();
            if (this.isLiteralString(node) && !this.isMultilineString(this.context.getNodeText(node))) {
                this.expressions = Collections.singletonList((Expression)node);
            } else if (node instanceof BinaryExpression && ((BinaryExpression)node).getOperation().getType() == 200) {
                TypeLookupResult result = this.context.getNodeType(node);
                if (VariableScope.STRING_CLASS_NODE.equals((Object)result.type)) {
                    LinkedList<Expression> stack;
                    BinaryExpression expr;
                    block10: {
                        expr = (BinaryExpression)node;
                        stack = new LinkedList<Expression>();
                        block3: while (true) {
                            stack.addFirst(expr.getRightExpression());
                            if (!(expr.getLeftExpression() instanceof BinaryExpression)) break block10;
                            expr = (BinaryExpression)expr.getLeftExpression();
                            switch (expr.getOperation().getType()) {
                                case 200: {
                                    continue block3;
                                }
                            }
                            break;
                        }
                        return 0;
                    }
                    stack.addFirst(expr.getLeftExpression());
                    for (Expression e : stack) {
                        if (!this.isLiteralString((ASTNode)e)) continue;
                        this.expressions = stack;
                        break;
                    }
                }
            }
        }
        return !this.expressions.isEmpty() ? 10 : 0;
    }

    @Override
    protected TextChange getTextChange(IProgressMonitor monitor) {
        monitor.beginTask(this.getDisplayString(), 1 + this.expressions.size());
        boolean interpolated = false;
        for (Expression expr : this.expressions) {
            if (!this.isGString((ASTNode)expr) && this.isLiteralString((ASTNode)expr)) continue;
            interpolated = true;
            break;
        }
        char quote = interpolated ? (char)'\"' : '\'';
        char[] source = this.context.getCompilationUnit().getContents();
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new InsertEdit(this.expressions.get(0).getStart(), String.valueOf(new char[]{quote, quote, quote})));
        monitor.worked(1);
        Expression last = null;
        for (Expression expr : this.expressions) {
            String replacement;
            boolean isLiteralString = this.isLiteralString((ASTNode)expr);
            boolean hasTripleQuotes = isLiteralString && this.isMultilineString(this.context.getNodeText((ASTNode)expr));
            int length = 0;
            int offset = expr.getStart();
            String string = replacement = isLiteralString ? "" : "${";
            if (last != null) {
                while (offset > 0 && source[offset - 1] == '+' || Character.isWhitespace(source[offset - 1])) {
                    ++length;
                    --offset;
                }
                if (!(expr.getLineNumber() == last.getLastLineNumber() || this.isLiteralString((ASTNode)last) && this.isNewlineTerminated(this.context.getNodeText((ASTNode)last)))) {
                    replacement = String.valueOf('\\') + this.unescaped('n') + replacement;
                }
            }
            if (isLiteralString) {
                length += hasTripleQuotes ? 3 : 1;
            } else if (expr instanceof ClosureExpression) {
                ++length;
            }
            edit.addChild((TextEdit)new ReplaceEdit(offset, length, replacement));
            if (isLiteralString) {
                int max;
                List<ConstantExpression> strings = this.getStrings(expr);
                int min = offset + length;
                int end = max = expr.getEnd() - (hasTripleQuotes ? 3 : 1);
                for (ConstantExpression str : strings) {
                    end = Math.min(str.getEnd(), max);
                    int pos = Math.max(str.getStart(), min);
                    while (pos < end) {
                        if (!(last != null || pos != min ? pos == max - 1 && expr == this.expressions.get(this.expressions.size() - 1) && this.escapeTrailingQuote(pos, quote, source, (TextEdit)edit) : this.escapeLeadingQuote(pos, end, quote, source, (TextEdit)edit))) {
                            if (this.escapeTripleQuotes(pos, end - 1, quote, source, (TextEdit)edit)) {
                                pos += 2;
                            } else if (source[pos] == '\\' && (pos != max - 2 || source[pos + 1] != quote) && (replacement = this.unescaped(source[pos + 1])) != null) {
                                edit.addChild((TextEdit)new ReplaceEdit(pos++, 2, replacement));
                            } else if (interpolated && source[pos] == '$' && !this.isGString((ASTNode)expr)) {
                                edit.addChild((TextEdit)new InsertEdit(pos++, "\\"));
                            }
                        }
                        ++pos;
                    }
                }
                edit.addChild((TextEdit)new ReplaceEdit(end, hasTripleQuotes ? 3 : 1, ""));
            } else if (!(expr instanceof ClosureExpression)) {
                edit.addChild((TextEdit)new InsertEdit(expr.getEnd(), "}"));
            }
            last = expr;
            monitor.worked(1);
        }
        edit.addChild((TextEdit)new InsertEdit(this.expressions.get(this.expressions.size() - 1).getEnd(), String.valueOf(new char[]{quote, quote, quote})));
        return this.toTextChange((TextEdit)edit);
    }

    private boolean escapeLeadingQuote(int pos, int max, char quote, char[] source, TextEdit textEdit) {
        if (source[pos] == quote) {
            textEdit.addChild((TextEdit)new InsertEdit(pos, "\\"));
            return true;
        }
        return pos + 1 < max && source[pos] == '\\' && source[pos + 1] == quote;
    }

    private boolean escapeTrailingQuote(int pos, char quote, char[] source, TextEdit textEdit) {
        if (source[pos] == quote) {
            if (source[pos - 1] != '\\') {
                TextEdit e = textEdit.getChildren()[textEdit.getChildrenSize() - 1];
                if (e.getOffset() != pos || !(e instanceof InsertEdit)) {
                    textEdit.addChild((TextEdit)new InsertEdit(pos, "\\"));
                }
            } else {
                TextEdit e = textEdit.getChildren()[textEdit.getChildrenSize() - 1];
                Assert.isLegal((e.getOffset() != pos - 1 || !(e instanceof ReplaceEdit) ? 1 : 0) != 0);
            }
            return true;
        }
        return false;
    }

    private boolean escapeTripleQuotes(int pos, int max, char quote, char[] source, TextEdit textEdit) {
        if (pos + 2 < max && source[pos] == quote && source[pos - 1] != '\\') {
            if (source[pos + 1] == quote) {
                if (source[pos + 2] == quote) {
                    textEdit.addChild((TextEdit)new ReplaceEdit(pos, 3, String.valueOf(new char[]{'\\', quote, '\\', quote, '\\', quote})));
                    return true;
                }
                if (pos + 3 < max && source[pos + 2] == '\\' && source[pos + 3] == quote) {
                    return true;
                }
            } else if (pos + 3 < max && source[pos + 1] == '\\' && source[pos + 2] == quote) {
                if (source[pos + 3] == quote) {
                    return true;
                }
                if (pos + 4 < max && source[pos + 3] == '\\' && source[pos + 4] == quote) {
                    return true;
                }
            }
        }
        return false;
    }

    private List<ConstantExpression> getStrings(Expression expr) {
        if (this.isGString((ASTNode)expr)) {
            return ((GStringExpression)expr).getStrings();
        }
        return Collections.singletonList((ConstantExpression)expr);
    }

    private boolean isGString(ASTNode node) {
        return node instanceof GStringExpression;
    }

    private boolean isLiteralString(ASTNode node) {
        if ((this.isGString(node) || node instanceof ConstantExpression && ((ConstantExpression)node).getValue() instanceof String) && node.getEnd() > node.getStart()) {
            return this.isLiteralString(this.context.getNodeText(node));
        }
        return false;
    }

    private boolean isLiteralString(String nodeText) {
        boolean result = false;
        int length = nodeText.length();
        if (length > 1) {
            char first = nodeText.charAt(0);
            char last = nodeText.charAt(length - 1);
            result = (first == '\'' || first == '\"') && first == last;
        }
        return result;
    }

    private boolean isMultilineString(String nodeText) {
        boolean result = false;
        if (nodeText.startsWith("\"\"\"") && nodeText.endsWith("\"\"\"")) {
            result = true;
        } else if (nodeText.startsWith("'''") && nodeText.endsWith("'''")) {
            result = true;
        }
        return result;
    }

    private boolean isNewlineTerminated(String nodeText) {
        boolean result = false;
        int i = nodeText.length() - (this.isMultilineString(nodeText) ? 3 : 1) - 1;
        if (i > 1) {
            result = nodeText.charAt(i) == '\n' || nodeText.charAt(i) == 'n' && nodeText.charAt(i - 1) == '\\';
        }
        return result;
    }

    private String unescaped(char escaped) {
        switch (escaped) {
            case '\'': {
                return "'";
            }
            case '\"': {
                return "\"";
            }
            case 't': {
                return "\t";
            }
            case '\\': {
                return "\\";
            }
            case 'n': {
                if (this.lineDelimiter == null) {
                    this.lineDelimiter = this.context.getLineDelimiter(null, 1);
                }
                return this.lineDelimiter;
            }
        }
        return null;
    }
}

