/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistContext;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.AddInferencingSuggestionProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.AssignStatementToNewLocalProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertAccessorToPropertyProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertClosureDefToMethodProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertMethodDefToClosureProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertToMultiLineStringProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertToSingleLineStringProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ConvertVariableToFieldProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ExtractToConstantProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ExtractToLocalProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.InlineLocalVariableProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.RemoveSpuriousSemicolonsProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.ReplaceDefWithStaticTypeProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.SplitVariableDeclAndInitProposal;
import org.codehaus.groovy.eclipse.quickassist.proposals.SwapLeftAndRightOperandsProposal;
import org.codehaus.groovy.eclipse.quickfix.GroovyQuickFixPlugin;
import org.codehaus.groovy.eclipse.quickfix.templates.GroovyContext;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class GroovyQuickAssist
implements IQuickAssistProcessor {
    private static final String LINE_SELECTION_TEMPLATE = "${line_selection}";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        return this.getAssists(context, new IProblemLocation[0]).length > 0;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (!GroovyQuickFixPlugin.isGroovyProject(context) || !(context.getCompilationUnit() instanceof GroovyCompilationUnit)) {
            return new IJavaCompletionProposal[0];
        }
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        if (context instanceof IQuickAssistInvocationContext) {
            proposals.addAll(this.getTemplateAssists((IQuickAssistInvocationContext)context, (GroovyCompilationUnit)context.getCompilationUnit()));
        }
        GroovyQuickAssistContext gcontext = new GroovyQuickAssistContext(context);
        GroovyQuickAssistProposal[] groovyQuickAssistProposalArray = new GroovyQuickAssistProposal[]{new AddInferencingSuggestionProposal(), new AssignStatementToNewLocalProposal(), new ConvertAccessorToPropertyProposal(), new ConvertClosureDefToMethodProposal(), new ConvertMethodDefToClosureProposal(), new ConvertToMultiLineStringProposal(), new ConvertToSingleLineStringProposal(), new ConvertVariableToFieldProposal(), new ExtractToConstantProposal(true), new ExtractToConstantProposal(false), new ExtractToLocalProposal(true), new ExtractToLocalProposal(false), new InlineLocalVariableProposal(), new RemoveSpuriousSemicolonsProposal(), new ReplaceDefWithStaticTypeProposal(), new SplitVariableDeclAndInitProposal(), new SwapLeftAndRightOperandsProposal()};
        int n = groovyQuickAssistProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            GroovyQuickAssistProposal proposal = groovyQuickAssistProposalArray[n2];
            if (proposal.withContext(gcontext).getRelevance() > 0) {
                proposals.add(proposal);
            }
            ++n2;
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    public List<IJavaCompletionProposal> getTemplateAssists(IQuickAssistInvocationContext context, GroovyCompilationUnit unit) {
        IDocument document = null;
        ISourceViewer viewer = context.getSourceViewer();
        if (viewer != null) {
            document = viewer.getDocument();
        }
        Region region = new Region(context.getOffset(), context.getLength());
        if (document != null && region.getLength() > 1) {
            try {
                ContextTypeRegistry templateContextRegistry = GroovyQuickFixPlugin.getDefault().getTemplateContextRegistry();
                TemplateContextType contextType = templateContextRegistry.getContextType("groovy");
                GroovyContext templateContext = new GroovyContext(contextType, document, region.getOffset(), region.getLength(), (ICompilationUnit)unit);
                templateContext.setForceEvaluation(true);
                templateContext.setVariable("line_selection", document.get(region.getOffset(), region.getLength()));
                ArrayList<IJavaCompletionProposal> templates = new ArrayList<IJavaCompletionProposal>();
                Template[] templateArray = GroovyQuickFixPlugin.getDefault().getTemplateStore().getTemplates();
                int n = templateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template = templateArray[n2];
                    if (GroovyQuickAssist.isSurroundWith(template, templateContext)) {
                        templates.add((IJavaCompletionProposal)new TemplateProposal(template, (TemplateContext)templateContext, (IRegion)region, null));
                    }
                    ++n2;
                }
                return templates;
            }
            catch (BadLocationException e) {
                GroovyQuickFixPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    private static boolean isSurroundWith(Template template, JavaContext templateContext) {
        String contextId = templateContext.getContextType().getId();
        return "groovy".equals(contextId) && template.getPattern().indexOf(LINE_SELECTION_TEMPLATE) != -1;
    }
}

