
# Build script for OSX using AdaCore Ada
#
# Example script that avoids Xcode g++
# and uses shared library liboal.so

# 100% AdaCore using shared OpenAL binding...
# works nicely using liboal.so
# providing its install_name is properly set.

# In nov2021 my Xcode was upgraded to 10.1 but
# my MacBookPro TBD files became "out-of-sync"
# with SDK libraries. I must now give specific path
# to libraries & frameworks.


#!/bin/sh

# this ensures a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# set priority path to AdaCore compiler:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH


export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks


# now using -lstdc++
# I believe using -lc++ is Ok too.

# assumes liboal.so is present


gnatmake  $1 -O3  \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adautils/fakeTime \
-I$PWD/adabindings/fake00 \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-largs \
$PWD/libs/osx/libgnatcoll.a \
$PWD/libs/osx/liboal.so \
\
-L$SDKROOT/usr/lib \
-lm -lz -lstdc++ \
\
-F$FWROOT \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread 

mv $1 ./bin/osx/


# next line was NOT necessary:
#-Xlinker -rpath -Xlinker '@executable_path/libs/osx' \
# but the install_path of liboal.so must be set properly
# ...see ./adabindings/adaOpenAL/OalBinding/ocmp.sh

