# osx compile script for coterminal apps
# Nonstandard libraries are now static.
#
# Note the -Xlinker statement tells the system
# where to find the [non-standard] Frameworks 
# relative to the directory in which the 
# executable resides.

##################################################
# Now, we use AdaCore:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH


gnatmake $1 \
-O3  \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adainclude \
-I$PWD/adainclude/sfmlAudio \
-I$PWD/adainclude/fakeTime \
-I$PWD/adabindings/fake00 \
-largs -lm -lz -lc++ \
$PWD/libs/osx_static/libgnatcoll.a \
$PWD/libs/osx_static/libgpr.a \
$PWD/libs/osx_static/libiconv.a \
$PWD/libs/osx_static/libopenal.a \
$PWD/libs/osx_static/libsfml250-audio-s.a \
$PWD/libs/osx_static/libsfml250-system-s.a \
\
$PWD/obj/snd4ada.o \
\
-Xlinker -rpath -Xlinker @loader_path/../../libs/osx/Frameworks \
\
-F$PWD/libs/osx/Frameworks/ \
-framework FLAC -framework ogg \
-framework vorbis -framework vorbisenc -framework vorbisfile \
\
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-pthread



mv $1 ./bin/osx/


# -- Copyright (C) 2020  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

