/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.nodes.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * Properties 型のデータを表す値型のノードを提供します。
 */
public class PropertiesNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        final Class[] paramTypes = new Class[] { InputStream.class };

        String type = getAttribute("type", "java.util.Properties");
        String filepath = getText();
        Properties properties = null;
        try {

            properties = (Properties) ResourceLoader.getInstance(type, getContext().getClassLoader());
            InputStream inStream = ResourceLoader.getResourceAsStream(filepath, getContext().getClassLoader());
            properties.load(inStream);

        } catch (ObjectCreationException e) {
            throw new GinkgoException("illegal class name is specified. class:" + type, e);
        } catch (NoSuchResourceException e) {
            throw new GinkgoException("no such resource. path:" + filepath, e);
        } catch (IOException e) {
            throw new GinkgoException("invoke load method errpor. path:" + filepath, e);
        }

        return properties;
    }
}