/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.base;

import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * 説明文を表すコメント型のノードを提供します。 値ノードでは無いですが、コメント文を値として返却します。
 */
public class CommentNode extends AbstractValueNode {

    /**
     * 有効なノード種別を返却します。
     * 
     * @return 有効なノード種別
     */
    protected int[] getTypes() {
        return new int[] { TYPE_COMMENT };
    }

    /**
     * ノードの固有のスコープを返却します。
     * 
     * @return ノードの固有のスコープ
     */
    protected int getNodeScope() {
        return SCOPE_OWNER;
    }

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        return getText();
    }

}
