/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes;

/**
 * デフォルトの値ノードの抽象実装を提供し実装の負担を最小化します。
 */
public abstract class AbstractValueNode extends AbstractDefaultNode {

    /* 値をキャッシュします。 */
    private Object cacheValue;

    /**
     * デフォルトで<code>Node.TYPE_VALUE</code>を持つ配列を返却します。
     * 
     * @return <code>Node.TYPE_VALUE</code>を持つ配列
     */
    protected int[] getTypes() {
        return new int[] { TYPE_VALUE };
    }

    /**
     * デフォルトで<code>Node.PUBLIC</code>を返却します。
     * 
     * @return <code>Node.PUBLIC</code>
     */
    protected int getNodeScope() {
        return SCOPE_PUBLIC;
    }

    /**
     * 値のキャッシュを返却します。
     * 
     * @return 値のキャッシュ
     */
    protected Object getCacheValue() {
        return cacheValue;
    }

    /**
     * cacheValue を格納します。
     * 
     * @param o
     *            値のキャッシュ
     */
    protected void setCacheValue(Object o) {
        this.cacheValue = o;
    }

    /**
     * ノードの値表現を返却します。
     * 
     * @return ノードの値表現
     */
    public Object getNodeValue() {
        if (null == this.cacheValue) {
            this.cacheValue = generateValue();
        }
        return this.cacheValue;
    }

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    abstract protected Object generateValue();

}
