/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo;

/**
 * ノードの属性やテキスト文字列を代入する機能を提供します。
 */
public interface Substitutor {

    /**
     * ノードの属性を代入して返す。
     * 
     * @param document
     *            ドキュメント
     * @param uri
     *            ノードの階層URI
     * @param nodeName
     *            ノードのタグ名
     * @param atts
     *            ノードの属性情報
     * @return 代入された属性を含むタグの属性
     */
    TagAttributes substitute(Document document, String uri, String nodeName, TagAttributes atts);

    /**
     * テキスト文字列を代入して返す。
     * 
     * @param document
     *            ドキュメント
     * @param uri
     *            ノードの階層URI
     * @param nodeName
     *            ノードのタグ名
     * @param text
     *            テキスト文字列
     * @return 代入されたテキスト文字列
     */
    String substitute(Document document, String uri, String nodeName, String text);

}
