/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo;

/**
 * XMLドキュメントのノードを構造化されたオブジェクトに合成するルールを提供します。
 */
public interface NodeCompositeRule {

    /**
     * ノードの構成情報を返却します。
     * 
     * @param namespaceURI
     *            解析対象の名前空間URI
     * @param nodeURI
     *            解析対象のXML階層URI
     * @param tagName
     *            タグ名
     * @return ノード構成情報
     */
    NodeRule findNodeRule(String namespaceURI, String nodeURI, String tagName);

    /**
     * 指定された識別子が示す拡張機能を返却します。 <br>
     * 指定された識別子に対応する拡張機能が存在しない場合<code>null</code>を返却します。
     * 
     * @param id
     *            機能を示すクラス
     * @return 拡張機能
     */
    Object getFeature(Class id);

    /**
     * 解析処理の直前に呼び出されます、処理のフックポイントの役割を持ちます。
     * 
     * @param ginkgo
     *            解析処理を実行する<code>Ginkgo</code>
     * @param document
     *            解析対象のドキュメント
     */
    void parse(Ginkgo ginkgo, Document document);
}
