/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * 個々のノード属性の構成ルールを表現する機能を提供します。
 */
public final class NodeAttributesRule {

    /* 属性名 */
    private final String name;

    /* 別名 */
    private final String alias;

    /* デフォルト値 */
    private final String defaultValue;

    /**
     * 属性のルールを設定して初期化します。
     * 
     * @param name
     *            属性名
     * @param alias
     *            別名
     * @param defaultValue
     *            デフォルト値
     */
    public NodeAttributesRule(String name, String alias, String defaultValue) {
        this.name = name;
        this.alias = alias;
        this.defaultValue = defaultValue;
    }

    /**
     * 別名を返却します。
     * 
     * @return 別名
     */
    public String getAlias() {
        return alias;
    }

    /**
     * デフォルト値を返却します。
     * 
     * @return デフォルト値
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * 属性名を返却します。
     * 
     * @return 属性名
     */
    public String getName() {
        return name;
    }
}
