/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.Iterator;
import shohaku.core.beans.BeansFactory;
import shohaku.core.beans.ClassInfo;
import shohaku.core.beans.FactoryMethodInfo;
import shohaku.core.beans.FieldInfo;
import shohaku.core.beans.MethodInfo;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

public class BeansFactoryNode
extends AbstractValueNode {
    protected Object generateValue() {
        Class objectClass;
        String instanceType = this.getAttribute("instance", "singleton");
        ClassInfo ci = new ClassInfo();
        String className = this.getAttribute("class", "java.lang.Object");
        try {
            objectClass = ResourceLoader.getClass((String)className, (ClassLoader)this.getContext().getClassLoader());
        }
        catch (NoSuchResourceException e) {
            throw new GinkgoException("illegal class name is specified. " + className, e);
        }
        ci.setObjectType(objectClass);
        Iterator i = this.getContext().valueElementIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            Object o = n.getNodeValue();
            if (o instanceof FieldInfo) {
                ci.addField((FieldInfo)o);
                continue;
            }
            if (o instanceof MethodInfo) {
                ci.addInitMethod((MethodInfo)o);
                continue;
            }
            if (o instanceof FactoryMethodInfo) {
                if (ci.getFactory() != null) {
                    throw new GinkgoException("FactoryMethodInfo except for one is illegal. element:" + o);
                }
                ci.setFactory((FactoryMethodInfo)o);
                continue;
            }
            throw new GinkgoException("element node of the illegal type. element:" + o);
        }
        return new BeansFactory(ci, ci.getObjectType(), instanceType);
    }
}

