/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.nodes;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.helpers.Eval;
import shohaku.core.lang.LangUtils;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELFormatException;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeContext;

public class NodeCompositeUtilities {
    public static final String[] BOOL_STRINGS = new String[]{"true", "false", "yes", "no", "on", "off", "1", "0"};
    public static final String[] TRUE_STRINGS = new String[]{"true", "yes", "on", "1"};
    private static final Pattern numberPattern = Pattern.compile("^[-+]?(?:0|0X|0x)?[0-9-a-fA-F](?:[-+0-9-a-fA-F,]*[-+0-9-a-fA-F])?(?:\\.[-+0-9-a-fA-F]+)?$");
    private static final Pattern numberRemovePattern = Pattern.compile("^\\+|,");
    private static final Pattern referenceExPattern = Pattern.compile("([#$%]\\{(?:\\\\\\}|[^}])*\\})");
    private static final Pattern referenceExRemovePattern = Pattern.compile("\\\\\\}");

    public static boolean isBoolean(String value) {
        return Eval.isContains((Object[])BOOL_STRINGS, (Object)value.toLowerCase());
    }

    public static boolean getBoolean(String value) {
        return Eval.isContains((Object[])TRUE_STRINGS, (Object)value.toLowerCase());
    }

    public static String getTextValueToString(NodeContext context) {
        StringBuffer sb = new StringBuffer();
        Iterator i = context.textIterator();
        while (i.hasNext()) {
            sb.append(((Node)i.next()).getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getChildrenValueToString(NodeContext context) {
        StringBuffer sb = new StringBuffer();
        Iterator i = context.valueIterator();
        while (i.hasNext()) {
            sb.append(((Node)i.next()).getNodeValue());
        }
        return sb.toString().trim();
    }

    public static Object toCELValue(NodeContext context, String value) {
        try {
            return CELBinder.getObjectCreationBinder().getValue(value, (CELContext)new CELContextImpl(context));
        }
        catch (CELFormatException e) {
            throw new GinkgoException("value:" + value, e);
        }
    }

    public static Object getReferenceNodeValue(NodeContext context, String id) {
        return context.getDocument().getNodeValueById(id);
    }

    public static Object getDocumentContextAttribute(NodeContext context, String name) {
        DocumentContext docContext = context.getDocumentContext();
        return docContext.getAttribute(name);
    }

    public static Object getReferenceValue(NodeContext context, String id) {
        Object o = null;
        if (!Eval.isBlankOrSpace((CharSequence)id)) {
            o = context.getDocument().containsId(id) ? NodeCompositeUtilities.getReferenceNodeValue(context, id) : NodeCompositeUtilities.getDocumentContextAttribute(context, id);
        }
        return o;
    }

    public static boolean isReferenceContainsName(NodeContext context, String id) {
        boolean ret = false;
        if (!Eval.isBlankOrSpace((CharSequence)id) && !(ret = context.getDocument().containsId(id))) {
            ret = context.getDocumentContext().containsName(id);
        }
        return ret;
    }

    public static Class loadClass(NodeContext context, String className) {
        try {
            return LangUtils.loadClass((String)className, (ClassLoader)context.getClassLoader());
        }
        catch (NoSuchResourceException e) {
            throw new GinkgoException("Class couldn't be created. name:" + className, e);
        }
    }

    public static String toJavaNumberString(CharSequence value) {
        if (numberPattern.matcher(value).matches()) {
            return numberRemovePattern.matcher(value).replaceAll("");
        }
        throw new NumberFormatException("value:" + value);
    }

    public static String filterReferenceExpression(Document document, String s) {
        StringBuffer sb = new StringBuffer(s.length());
        Matcher m = referenceExPattern.matcher(s);
        int i = 0;
        while (i < s.length()) {
            if (m.find(i)) {
                sb.append(s.substring(i, m.start(1)));
                String refex = referenceExRemovePattern.matcher(m.group(1)).replaceAll("}");
                char mark = refex.charAt(0);
                String id = refex.substring(2, refex.length() - 1);
                Object value = NodeCompositeUtilities.getReferenceExpressionValue(document, mark, id);
                sb.append(value);
                i = m.end(1);
                continue;
            }
            sb.append(s.substring(i));
            break;
        }
        return sb.toString();
    }

    private static Object getReferenceExpressionValue(Document document, char mark, String id) {
        Object o = null;
        o = mark == '$' ? document.getContext().getAttribute(id) : document.getNodeValueById(id);
        return o;
    }

    private static class CELContextImpl
    implements CELContext {
        final NodeContext context;

        CELContextImpl(NodeContext context) {
            this.context = context;
        }

        public Iterator nameIterator() {
            Iterator[] iters = new Iterator[]{this.context.getDocument().getNodeValueIdIterator(), this.context.getDocumentContext().getAttributeNameIterator()};
            return IteratorUtils.compositeIterator((Iterator[])iters);
        }

        public Object getValue(String name) {
            return NodeCompositeUtilities.getReferenceValue(this.context, name);
        }

        public Object setValue(String name, Object value) {
            return this.context.getDocumentContext().setAttribute(name, value);
        }

        public boolean containsName(String name) {
            return NodeCompositeUtilities.isReferenceContainsName(this.context, name);
        }
    }
}

