/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import shohaku.core.collections.ListUtils;
import shohaku.core.collections.params.Parameters;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeAttributesRule;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.NodeRule;
import shohaku.ginkgo.TagAttributes;

public class NodeContext {
    private Document document;
    private NodeRule nodeRule;
    private Node parent;
    private String nodeURI;
    private String nodeNamespaceURI;
    private String nodeLocalName;
    private String nodeQName;
    private String nodeName;
    private TagAttributes attributes;
    private List children;

    NodeContext(Document document, NodeRule nodeRule, Node parent, String uri, String namespace, String localName, String qName, String nodeName, TagAttributes attributes) {
        this.document = document;
        this.nodeRule = nodeRule;
        this.parent = parent;
        this.nodeURI = uri;
        this.nodeNamespaceURI = namespace;
        this.nodeLocalName = localName;
        this.nodeQName = qName;
        this.nodeName = nodeName;
        this.attributes = attributes;
        this.children = new LinkedList();
    }

    public Document getDocument() {
        return this.document;
    }

    public Ginkgo getGinkgo() {
        return this.getDocumentContext().getGinkgo();
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.getDocumentContext().getNodeCompositeRule();
    }

    public DocumentContext getDocumentContext() {
        return this.getDocument().getContext();
    }

    public DocumentCompositeRule getDocumentCompositeRule() {
        return this.getGinkgo().getDocumentCompositeRule();
    }

    public ClassLoader getClassLoader() {
        return this.getGinkgo().getClassLoader();
    }

    public String getNodeQName() {
        return this.nodeQName;
    }

    public String getNodeLocalName() {
        return this.nodeLocalName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeNamespaceURI() {
        return this.nodeNamespaceURI;
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean isChildEmpty() {
        return this.children.isEmpty();
    }

    public boolean isElementEmpty() {
        int count = 0;
        Iterator i = this.elementIterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count == 0;
    }

    public Iterator childIterator() {
        return this.children.iterator();
    }

    public List getChildren() {
        return this.children;
    }

    public Iterator textIterator() {
        Iterator i = this.childIterator();
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return n.isType(2);
            }
        };
    }

    public List getTextChildren() {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.textIterator());
    }

    public Iterator elementIterator() {
        Iterator i = this.childIterator();
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return !n.isType(2);
            }
        };
    }

    public List getElementChildren() {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.elementIterator());
    }

    public Iterator elementIterator(String nodeName) {
        Iterator i = this.childIterator();
        final String nm = nodeName;
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return !n.isType(2) && nm.equals(n.getContext().getNodeName());
            }
        };
    }

    public List getElementChildren(String nodeName) {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.elementIterator(nodeName));
    }

    public Iterator ownerIterator() {
        Iterator i = this.childIterator();
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return 101 >= n.getScope();
            }
        };
    }

    public List getOwnerChildren() {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.ownerIterator());
    }

    public Iterator valueIterator() {
        Iterator i = this.childIterator();
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return n.isType(3);
            }
        };
    }

    public List getValueChildren() {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.valueIterator());
    }

    public Iterator valueElementIterator() {
        Iterator i = this.childIterator();
        return new SelectionNodeIterator(i){

            boolean select(Node n) {
                return n.isType(3) && !n.isType(2);
            }
        };
    }

    public List getValueElementChildren() {
        return ListUtils.addAll(new LinkedList(), (Iterator)this.valueElementIterator());
    }

    public Parameters getXAttributes() {
        return this.nodeRule.getXAttributes();
    }

    public String getXAttribute(String name) {
        return (String)this.getXAttributes().getValue(name);
    }

    public String getXAttribute(String name, String defaultValue) {
        return (String)this.getXAttributes().getValue(name, defaultValue);
    }

    public Parameters getNodeAttributesRules() {
        return this.nodeRule.getNodeAttributesRules();
    }

    public NodeAttributesRule getNodeAttributesRule(String name) {
        return (NodeAttributesRule)this.getNodeAttributesRules().getValue(name);
    }

    public TagAttributes getTagAttributes() {
        return this.attributes;
    }

    public String getTagAttribute(String name) {
        return this.getTagAttributes().getValue(name);
    }

    public String getTagAttribute(String name, String defaultValue) {
        String value = this.getTagAttribute(name);
        return value != null ? value : defaultValue;
    }

    void addChild(Node child) {
        this.children.add(child);
    }

    private static abstract class SelectionNodeIterator
    implements Iterator {
        private final Object NULL = new Object();
        private final Object NOSUCH = new Object();
        private final Iterator i;
        private Object next = this.NULL;

        SelectionNodeIterator(Iterator iter) {
            this.i = iter;
        }

        public void remove() {
            this.i.remove();
        }

        public boolean hasNext() {
            while (this.i.hasNext()) {
                Node n = (Node)this.i.next();
                if (!this.select(n)) continue;
                this.next = n;
                return true;
            }
            this.next = this.NOSUCH;
            return false;
        }

        public Object next() {
            if (this.next == this.NULL) {
                throw new IllegalStateException();
            }
            if (this.next == this.NOSUCH) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        abstract boolean select(Node var1);
    }
}

