/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.collections.MapUtils;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;

public class DocumentContext {
    private final Ginkgo ginkgo;
    private final NodeCompositeRule rule;
    private Node root;
    private final HashMap attributes = new HashMap();

    DocumentContext(Ginkgo ginkgo, NodeCompositeRule rule) {
        this.ginkgo = ginkgo;
        this.rule = rule;
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.rule;
    }

    public Ginkgo getGinkgo() {
        return this.ginkgo;
    }

    public ClassLoader getClassLoader() {
        return this.getGinkgo().getClassLoader();
    }

    public Node getRoot() {
        return this.root;
    }

    void setRoot(Node root) {
        this.root = root;
    }

    public Iterator getAttributeNameIterator() {
        return this.attributes.keySet().iterator();
    }

    public boolean containsName(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getAttributePrefix(String prefix) {
        return MapUtils.putPrefixKey((Map)this.attributes, (String)prefix, new HashMap());
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.remove(name);
    }

    public Map removeAttributePrefix(String prefix) {
        return MapUtils.removePrefixKey((Map)this.attributes, (String)prefix, new HashMap());
    }

    public void removeAttributeAll() {
        this.attributes.clear();
    }
}

