/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.helpers.Cutter;
import shohaku.core.helpers.Eval;
import shohaku.core.helpers.Seek;
import shohaku.core.lang.LangUtils;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;

public class ObjectCreateExpression
implements CELExpression {
    private static final CELLiteral literal = new CELLiteral('@', '@');

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        char[] nextLiterals = "(#{@".toCharArray();
        char[] staticNextLiterals = "(@".toCharArray();
        String exp = expression;
        int off = ++beginIndex;
        Class type = null;
        String className = null;
        String staticMethodName = null;
        String staticFieldName = null;
        int nextIndex = Seek.orIndexOf(exp, nextLiterals, off = Seek.skipSp(exp, off));
        if (Eval.isNegative(nextIndex)) {
            throw new CELFormatException("format err:" + exp);
        }
        char offLiteral = exp.charAt(nextIndex);
        switch (offLiteral) {
            case 35: {
                className = exp.substring(off, nextIndex);
                int staticNextIndex = Seek.orIndexOf(exp, staticNextLiterals, nextIndex);
                if (Eval.isPositive(staticNextIndex)) {
                    if (Eval.isCharAt(exp, staticNextIndex, '(')) {
                        staticMethodName = exp.substring(nextIndex + 1, staticNextIndex);
                        offLiteral = '(';
                    } else {
                        staticFieldName = Cutter.trimEnd(exp.substring(nextIndex + 1, staticNextIndex));
                        offLiteral = '@';
                    }
                    off = staticNextIndex;
                    break;
                }
                throw new CELFormatException("format err:" + exp);
            }
            case 40: {
                className = exp.substring(off, nextIndex);
                off = nextIndex;
                break;
            }
            default: {
                className = Cutter.trimEnd(exp.substring(off, nextIndex));
                off = nextIndex;
            }
        }
        try {
            type = LangUtils.loadClass(className, null);
        }
        catch (NoSuchResourceException e) {
            throw new CELFormatException("bean invocation err:" + exp, e);
        }
        Object o = null;
        if (offLiteral == ObjectCreateExpression.literal.end) {
            if (staticFieldName != null) {
                try {
                    o = BeanUtilities.getFieldValue(type, null, staticFieldName);
                }
                catch (InvocationBeansException e) {
                    throw new CELFormatException("bean invocation err:" + exp, e);
                }
            } else {
                o = type;
            }
            off = Seek.skipSp(exp, off);
        } else if (offLiteral == '{') {
            Object a;
            if (!Eval.isArrayClass(type)) {
                throw new CELFormatException("no array type:" + exp);
            }
            CELReturnValue rValue = CELUtils.getArrayListReturnValue(binder, exp, off, context, '{', '}');
            List elems = (List)rValue.value;
            off = rValue.nextIndex;
            try {
                a = Array.newInstance(type.getComponentType(), elems.size());
                int index = 0;
                Iterator i = elems.iterator();
                while (i.hasNext()) {
                    Array.set(a, index, i.next());
                    ++index;
                }
            }
            catch (NegativeArraySizeException e) {
                throw new CELFormatException("array create err:" + exp, e);
            }
            catch (IllegalArgumentException e) {
                throw new CELFormatException("array create err:" + exp, e);
            }
            o = a;
            off = Seek.skipSp(exp, off);
        } else if (offLiteral == '(') {
            CELReturnValue rValue = CELUtils.getArguments(binder, exp, off, context);
            Object[] args = (Object[])rValue.value;
            off = rValue.nextIndex;
            try {
                o = staticMethodName != null ? BeanUtilities.invokeMethod(type, null, staticMethodName, args) : BeanUtilities.newInstance(type, args);
            }
            catch (InvocationBeansException e) {
                throw new CELFormatException("bean invocation err:" + exp, e);
            }
            if (o instanceof Void) {
                throw new CELFormatException("method return type void:" + exp);
            }
            if (!Eval.isCharAt(exp, off = Seek.skipSp(exp, off), ObjectCreateExpression.literal.end)) {
                off = this.doSetProperties(binder, exp, off, o, context);
            }
        } else {
            throw new CELFormatException("format err:" + exp);
        }
        if (!Eval.isCharAt(exp, off, ObjectCreateExpression.literal.end)) {
            throw new CELFormatException("format err:" + exp);
        }
        return new CELReturnValue(o, ++off);
    }

    private int doSetProperties(CELBinder binder, String exp, int off, Object o, CELContext context) {
        CELReturnValue rPropValue = CELUtils.getLinkedHashMapReturnValue(binder, exp, off, context, '{', '}');
        Map props = (Map)rPropValue.value;
        off = rPropValue.nextIndex;
        if (!props.isEmpty()) {
            try {
                BeanUtilities.setProperties(o, props);
            }
            catch (InvocationBeansException e) {
                throw new CELFormatException("format err:" + exp, e);
            }
        }
        off = Seek.skipSp(exp, off);
        return off;
    }
}

