/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import shohaku.core.helpers.Cutter;
import shohaku.core.helpers.Eval;
import shohaku.core.helpers.Seek;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;

public class NoLiteralExpression
implements CELExpression {
    private static final CELLiteral literal = new CELLiteral('\u0000', '\u0000');
    private static final char[] NUM_CHARS = "-+xX0123456789abcdefABCDEF.BSILFD".toCharArray();
    private static final char[] NUM_BEGIN_CHARS = "-+0123456789.".toCharArray();
    private static final char[] REF_CHARS = "_-:abcdefghijklnmopqrstuvwxyzABCDEFGHIJKLNMOPQRSTUVWXYZ0987654321".toCharArray();
    private static final char[] REF_BEGIN_CHARS = "_abcdefghijklnmopqrstuvwxyzABCDEFGHIJKLNMOPQRSTUVWXYZ".toCharArray();

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        int off = Seek.skipSp(expression, beginIndex);
        if (Eval.isStartsWith(expression, "null", off)) {
            return new CELReturnValue(null, off += "null".length());
        }
        if (Eval.isStartsWith(expression, "true", off)) {
            return new CELReturnValue(Boolean.TRUE, off += "true".length());
        }
        if (Eval.isStartsWith(expression, "false", off)) {
            return new CELReturnValue(Boolean.FALSE, off += "false".length());
        }
        if (Eval.isContains(NUM_BEGIN_CHARS, expression.charAt(off))) {
            return this.executeNumber(expression, off);
        }
        if (Eval.isContains(REF_BEGIN_CHARS, expression.charAt(off))) {
            return this.executeReference(expression, off, context);
        }
        throw new CELFormatException("format err :" + expression);
    }

    private CELReturnValue executeReference(String expression, int off, CELContext context) {
        int endIndex = Seek.skip((CharSequence)expression, REF_CHARS, off);
        Object ref = null;
        String refId = expression.substring(off, endIndex);
        if (!context.containsName(refId)) {
            throw new CELFormatException("format err, no contains id:" + expression);
        }
        ref = context.getValue(refId);
        return new CELReturnValue(ref, endIndex);
    }

    private CELReturnValue executeNumber(String expression, int off) {
        int endIndex = Seek.skip((CharSequence)expression, NUM_CHARS, off);
        Number num = null;
        String exp = expression.substring(off, endIndex);
        try {
            char numLiteral = Cutter.end(exp);
            String snum = Cutter.cut(exp, 0, 1);
            switch (numLiteral) {
                case 'B': {
                    num = Byte.decode(snum);
                    break;
                }
                case 'S': {
                    num = Short.decode(snum);
                    break;
                }
                case 'I': {
                    num = Integer.decode(snum);
                    break;
                }
                case 'L': {
                    num = Long.decode(snum);
                    break;
                }
                case 'F': {
                    num = Float.valueOf(snum);
                    break;
                }
                case 'D': {
                    num = Double.valueOf(snum);
                    break;
                }
                default: {
                    if (Eval.isContains(exp, '.')) {
                        num = Double.valueOf(exp);
                        break;
                    }
                    num = Integer.decode(exp);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new CELFormatException("format err :" + exp, e);
        }
        return new CELReturnValue(num, endIndex);
    }
}

