/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import shohaku.core.lang.Boxing;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;
import shohaku.core.util.codec.UnicodeEscapesCoder;

public class CharacterExpression
implements CELExpression {
    private static final CELLiteral literal = new CELLiteral('\'', '\'');

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        int nextIndex = CELUtils.findNextIndex(expression, beginIndex, CharacterExpression.literal.end);
        if (-1 == nextIndex) {
            throw new CELFormatException("format err :" + expression);
        }
        String exp = expression.substring(beginIndex + 1, nextIndex - 1);
        String schar = exp.replaceFirst("\\'", "'");
        if (schar.length() > 1) {
            schar = UnicodeEscapesCoder.decode(schar);
        }
        if (schar.length() != 1) {
            throw new CELFormatException("format err :" + exp);
        }
        return new CELReturnValue(Boxing.box(schar.charAt(0)), nextIndex);
    }
}

