/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import shohaku.core.helpers.Seek;
import shohaku.core.lang.Boxing;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CharacterExpression;
import shohaku.core.util.cel.DateTimeExpression;
import shohaku.core.util.cel.IntrospectExpression;
import shohaku.core.util.cel.ListExpression;
import shohaku.core.util.cel.MapExpression;
import shohaku.core.util.cel.NoLiteralExpression;
import shohaku.core.util.cel.ObjectCreateExpression;
import shohaku.core.util.cel.ReferenceExpression;
import shohaku.core.util.cel.RegexPatternExpression;
import shohaku.core.util.cel.SetExpression;
import shohaku.core.util.cel.StringExpression;

public class CELBinder {
    private final Map expressionMap;
    private final CELExpression[] expressions;
    private final Locale locale;
    private static final Character NO_LITERAL = Boxing.box('\u0000');
    private static final CELExpression[] baseTypeCreationExpressions;
    private static final CELBinder baseTypeCreationBinder;
    private static final CELExpression[] collectionCreationExpressions;
    private static final CELBinder collectionCreationBinder;
    private static final CELExpression[] objectCreationExpressions;
    private static final CELBinder objectCreationBinder;

    static {
        ArrayList<CELExpression> exps = new ArrayList<CELExpression>();
        exps.add(new NoLiteralExpression());
        exps.add(new CharacterExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        baseTypeCreationExpressions = exps.toArray(new CELExpression[0]);
        baseTypeCreationBinder = new CELBinder(baseTypeCreationExpressions);
        exps = new ArrayList();
        exps.add(new NoLiteralExpression());
        exps.add(new CharacterExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        exps.add(new ListExpression());
        exps.add(new SetExpression());
        exps.add(new MapExpression());
        collectionCreationExpressions = exps.toArray(new CELExpression[0]);
        collectionCreationBinder = new CELBinder(collectionCreationExpressions);
        exps = new ArrayList();
        exps.add(new NoLiteralExpression());
        exps.add(new CharacterExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        exps.add(new ListExpression());
        exps.add(new SetExpression());
        exps.add(new MapExpression());
        exps.add(new ObjectCreateExpression());
        exps.add(new ReferenceExpression());
        exps.add(new IntrospectExpression());
        objectCreationExpressions = exps.toArray(new CELExpression[0]);
        objectCreationBinder = new CELBinder(objectCreationExpressions);
    }

    public CELBinder() {
        this(Locale.getDefault(), new CELExpression[0]);
    }

    public CELBinder(CELExpression[] exps) {
        this(Locale.getDefault(), exps, CELBinder.toMappingExpressions(exps));
    }

    public CELBinder(Locale locale, CELExpression[] exps) {
        this(locale, exps, CELBinder.toMappingExpressions(exps));
    }

    private CELBinder(Locale locale, CELExpression[] exps, Map fsm) {
        this.expressions = exps;
        this.locale = locale;
        this.expressionMap = fsm;
    }

    public CELExpression[] getExpressions() {
        return (CELExpression[])this.expressions.clone();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getValue(String expression) {
        return this.getValue(expression, null);
    }

    public Object getValue(String expression, CELContext context) {
        return this.getValue(expression, 0, context);
    }

    public Object getValue(String expression, int beginIndex, CELContext context) {
        CELReturnValue rValue = this.getReturnValue(expression, beginIndex, context);
        return rValue.value;
    }

    public CELReturnValue getReturnValue(String expression, int beginIndex, CELContext context) {
        return this.execute(expression, beginIndex, context);
    }

    private CELReturnValue execute(String expression, int beginIndex, CELContext context) {
        char beginLiteral = expression.charAt(beginIndex = Seek.skipSp(expression, beginIndex));
        CELExpression exp = (CELExpression)this.expressionMap.get(Boxing.box(beginLiteral));
        if (exp == null) {
            exp = (CELExpression)this.expressionMap.get(NO_LITERAL);
            return exp.execute(this, expression, beginIndex, context);
        }
        return exp.execute(this, expression, beginIndex, context);
    }

    private static Map toMappingExpressions(CELExpression[] exps) {
        HashMap<Character, CELExpression> m = new HashMap<Character, CELExpression>((int)((double)exps.length * 1.5));
        int i = 0;
        while (i < exps.length) {
            CELLiteral literal = exps[i].getLiteral();
            m.put(Boxing.box(literal.begin), exps[i]);
            ++i;
        }
        return Collections.unmodifiableMap(m);
    }

    public static CELBinder getBaseTypeCreationBinder() {
        return baseTypeCreationBinder;
    }

    public static CELBinder getCollectionCreationBinder() {
        return collectionCreationBinder;
    }

    public static CELBinder getObjectCreationBinder() {
        return objectCreationBinder;
    }
}

