/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Locale;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;

public class XResourceBundleHelper {
    private static final int MAX_BUNDLES_SEARCHED = 4;
    private static final int BASE_INDEX = 0;
    private static final int LANGUAGE_INDEX = 1;
    private static final int COUNTRY_INDEX = 2;
    private static final int VARIANT_INDEX = 3;

    public static Object calculateLocaleBundleBase(String baseName, String bundleName) {
        if (baseName.length() == bundleName.length()) {
            return new Locale("", "");
        }
        if (baseName.length() < bundleName.length()) {
            int pos = baseName.length();
            String temp = bundleName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                return new Locale(temp, "", "");
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                return new Locale(language, temp, "");
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            return new Locale(language, country, temp);
        }
        throw new IllegalArgumentException("baseName:" + baseName + ", bundleName:" + bundleName);
    }

    public static Object getLocaleDefaultBundleBase() {
        return Locale.getDefault();
    }

    public static String[] candidateLocaleBundleNames(String baseName, Object bundleBase) {
        Locale locale = (Locale)bundleBase;
        String[] result = new String[4];
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result[0] = baseName;
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result[1] = temp.toString();
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result[2] = temp.toString();
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result[3] = temp.toString();
        return result;
    }

    public static String candidateLocaleBundleId(Object bundleBase) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Locale locale = (Locale)bundleBase;
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return "root";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(language);
        if (countryLength + variantLength > 0) {
            sb.append('_');
            sb.append(country);
            if (variantLength > 0) {
                sb.append('_');
                sb.append(variant);
            }
        }
        return sb.toString().toLowerCase();
    }

    public static InputStream getPropertiesBundleInputStream(ClassLoader loader, String bundleName) {
        String resName = String.valueOf(bundleName.replace('.', '/')) + ".properties";
        InputStream stream = null;
        try {
            stream = ResourceLoader.getResourceAsStream(resName, loader);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        if (stream != null) {
            return new BufferedInputStream(stream);
        }
        return null;
    }
}

