/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.VariableNumber;

public class VariableFloat
implements VariableNumber,
Comparable {
    private static final long serialVersionUID = -7346731887262027974L;
    private float value;

    public VariableFloat() {
        this(0.0f);
    }

    public VariableFloat(float value) {
        this.value = value;
    }

    public VariableFloat(double value) {
        this.value = (float)value;
    }

    public VariableFloat(String s) throws NumberFormatException {
        this.value = Float.valueOf(s).floatValue();
    }

    public VariableFloat(Number value) {
        this.value = value.floatValue();
    }

    public VariableFloat(VariableNumber value) {
        this.value = value.floatValue();
    }

    public float add(float val) {
        this.value += val;
        return this.value;
    }

    public float subtract(float val) {
        this.value -= val;
        return this.value;
    }

    public float multiply(float val) {
        this.value *= val;
        return this.value;
    }

    public float divide(float val) {
        this.value /= val;
        return this.value;
    }

    public float increment() {
        this.value += 1.0f;
        return this.value;
    }

    public float decrement() {
        this.value -= 1.0f;
        return this.value;
    }

    public Number getValue() {
        return Boxing.box(this.value);
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.setValue(value.floatValue());
    }

    public void setValue(VariableNumber value) {
        this.setValue(value.floatValue());
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Object obj) {
        VariableFloat anotherFloat = (VariableFloat)obj;
        float thisVal = this.value;
        float anotherVal = anotherFloat.value;
        return Float.compare(thisVal, anotherVal);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableFloat) {
            return Float.floatToIntBits(((VariableFloat)obj).floatValue()) == Float.floatToIntBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

