/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.beans.ObjectGenerator;
import shohaku.core.helpers.Cutter;
import shohaku.core.helpers.Eval;
import shohaku.core.helpers.Seek;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.text.Format;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;

public class BeanUtilities {
    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        return BeanUtilities.getPropertyDescriptors(bean.getClass());
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("argument is null.");
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public static Map getProperties(Object bean) throws InvocationBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            PropertyDescriptor[] ds = BeanUtilities.getPropertyDescriptors(bean);
            int i = 0;
            while (i < ds.length) {
                Method method = ds[i].getReadMethod();
                if (method != null) {
                    props.put(ds[i].getName(), method.invoke(bean, null));
                }
                ++i;
            }
            return props;
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException(e);
        }
    }

    public static Object setProperties(Object bean, Map props) throws InvocationBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Map propsDesc = BeanUtilities.getMapPropertyDescriptors(bean);
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String name = (String)e.getKey();
                PropertyDescriptor pd = (PropertyDescriptor)propsDesc.get(name);
                if (pd == null) {
                    throw new InvocationBeansException();
                }
                Method method = pd.getWriteMethod();
                if (method == null) {
                    throw new InvocationBeansException();
                }
                if (method == null) continue;
                Object value = e.getValue();
                method.invoke(bean, BeanUtilities.newParameterValues(new Object[]{value}));
            }
            return bean;
        }
        catch (ClassCastException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException(e);
        }
    }

    public static String toBeanString(Object bean) throws InvocationBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            StringBuffer sb = new StringBuffer();
            PropertyDescriptor[] ds = BeanUtilities.getPropertyDescriptors(bean);
            sb.append('{');
            int count = 0;
            int i = 0;
            while (i < ds.length) {
                Method method = ds[i].getReadMethod();
                if (method != null) {
                    if (count != 0) {
                        sb.append(',');
                    }
                    Object val = method.invoke(bean, null);
                    sb.append(ds[i].getName());
                    sb.append(':');
                    sb.append(Format.toString(val));
                    ++count;
                }
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException(e);
        }
    }

    public static Object getNestedProperty(Object bean, String pattern) throws InvocationBeansException {
        if (Eval.isOrNull(bean, pattern)) {
            throw new NullPointerException("argument is null.");
        }
        char[] nextChars = "[.".toCharArray();
        try {
            int off = 0;
            Object o = bean;
            while (off < pattern.length()) {
                if (Eval.isCharAt(pattern, off, '[')) {
                    String key = Cutter.cutIndexOf(pattern, ++off, ']');
                    if (o instanceof Map) {
                        o = ((Map)o).get(key);
                    } else {
                        int index = Integer.parseInt(key);
                        if (o instanceof List) {
                            o = ((List)o).get(index);
                        } else if (Eval.isArray(o)) {
                            o = Array.get(o, index);
                        } else {
                            throw new InvocationBeansException("illegal pattern:" + pattern);
                        }
                    }
                    off += key.length() + 1;
                    continue;
                }
                if (Eval.isCharAt(pattern, off, '.')) {
                    ++off;
                } else if (off != 0) {
                    throw new InvocationBeansException("illegal pattern:" + pattern);
                }
                int end = Seek.orIndexOf(pattern, nextChars, off);
                if (Eval.isPositive(end)) {
                    String propertyName = pattern.substring(off, end);
                    o = BeanUtilities.getProperty(o, propertyName);
                    off = end;
                    continue;
                }
                String propertyName = pattern.substring(off);
                o = BeanUtilities.getProperty(o, propertyName);
                off = pattern.length();
            }
            return o;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
        catch (NumberFormatException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
    }

    public static Object getCELNestedProperty(Object bean, String pattern) throws InvocationBeansException {
        if (Eval.isOrNull(bean, pattern)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            int off = 0;
            Object o = bean;
            CELBinder binder = CELBinder.getObjectCreationBinder();
            while (off < pattern.length()) {
                if (Eval.isCharAt(pattern, off, '[')) {
                    String key = Cutter.cutIndexOf(pattern, ++off, ']');
                    if (o instanceof Map) {
                        o = ((Map)o).get(key);
                    } else {
                        int index = Integer.parseInt(key);
                        if (o instanceof List) {
                            o = ((List)o).get(index);
                        } else if (Eval.isArray(o)) {
                            o = Array.get(o, index);
                        } else {
                            throw new InvocationBeansException("illegal pattern:" + pattern);
                        }
                    }
                    off += key.length() + 1;
                    continue;
                }
                if (Eval.isCharAt(pattern, off, '.')) {
                    ++off;
                } else if (off != 0) {
                    throw new InvocationBeansException("illegal pattern:" + pattern);
                }
                int end = Seek.orIndexOf(pattern, "[(.#".toCharArray(), off);
                if (-1 < end) {
                    if (Eval.isCharAt(pattern, end, '(')) {
                        String methodName = pattern.substring(off, end);
                        CELReturnValue args = CELUtils.getArguments(binder, pattern, end, null);
                        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
                        o = BeanUtilities.invokeMethod(c, o, methodName, (Object[])args.value);
                        off = args.nextIndex;
                        continue;
                    }
                    if (Eval.isCharAt(pattern, end, '#')) {
                        String fieldName = pattern.substring(off, end);
                        o = BeanUtilities.getFieldValue(o, fieldName);
                        off = end;
                        continue;
                    }
                    String propertyName = pattern.substring(off, end);
                    o = BeanUtilities.getProperty(o, propertyName);
                    off = end;
                    continue;
                }
                String propertyName = pattern.substring(off);
                o = BeanUtilities.getProperty(o, propertyName);
                off = pattern.length();
            }
            return o;
        }
        catch (CELFormatException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
        catch (NumberFormatException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
    }

    public static Object getProperty(Object bean, String propertyName) throws InvocationBeansException {
        if (Eval.isOrNull(bean, propertyName)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Class<?> beanClass = bean.getClass();
            Method method = BeanUtilities.getMatchingAccessibleMethod(beanClass, "get" + BeanUtilities.capitalize(propertyName));
            if (method == null) {
                method = BeanUtilities.getMatchingAccessibleMethod(beanClass, "is" + BeanUtilities.capitalize(propertyName));
            }
            if (method == null) {
                throw new InvocationBeansException("Not Matching property, class:" + beanClass + ", name:" + propertyName);
            }
            return method.invoke(bean, null);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("illegal property:" + propertyName, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("illegal property:" + propertyName, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("illegal property:" + propertyName, e);
        }
    }

    public static Object newInstance(Class c) throws InvocationBeansException {
        return BeanUtilities.newInstance(c, new Class[0], new Object[0]);
    }

    public static Object newInstance(Class c, Object[] parameterValues) throws InvocationBeansException {
        return BeanUtilities.newInstance(c, BeanUtilities.toClassArray(parameterValues), parameterValues);
    }

    public static Object newInstance(Class c, Class[] parameterTypes, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, parameterTypes, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Constructor constructor = BeanUtilities.getConstructor(c, parameterTypes);
            return constructor.newInstance(BeanUtilities.newParameterValues(parameterValues));
        }
        catch (SecurityException e) {
            throw new InvocationBeansException("Class#getConstructor class:" + c, e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (InstantiationException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
    }

    public static Object invokeMethod(Class c, Object obj, String methodName) throws InvocationBeansException {
        return BeanUtilities.invokeMethod(c, obj, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Class c, Object obj, String methodName, Object[] parameterValues) throws InvocationBeansException {
        return BeanUtilities.invokeMethod(c, obj, methodName, BeanUtilities.toClassArray(parameterValues), parameterValues);
    }

    public static Object invokeMethod(Class c, Object obj, String methodName, Class[] parameterTypes, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, methodName, parameterTypes, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, methodName, parameterTypes);
        if (method == null) {
            throw new InvocationBeansException("Not Matching method, class:" + c + ", name:" + methodName);
        }
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, BeanUtilities.newParameterValues(parameterValues));
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, BeanUtilities.newParameterValues(parameterValues));
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
    }

    public static Object invokeMethod(Class c, Object obj, Method method, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, method, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, BeanUtilities.newParameterValues(parameterValues));
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, BeanUtilities.newParameterValues(parameterValues));
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) throws InvocationBeansException {
        return BeanUtilities.getFieldValue(obj.getClass(), obj, fieldName);
    }

    public static Object getFieldValue(Class c, Object obj, String fieldName) throws InvocationBeansException {
        if (Eval.isOrNull(c, fieldName)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Field field = BeanUtilities.getField(c, fieldName);
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("illegal field:" + fieldName, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("illegal field:" + fieldName, e);
        }
    }

    public static Object setFieldValue(Object obj, String fieldName, Object newValue) throws InvocationBeansException {
        return BeanUtilities.setFieldValue(obj.getClass(), obj, fieldName, newValue);
    }

    public static Object setFieldValue(Class c, Object obj, String fieldName, Object newValue) throws InvocationBeansException {
        if (Eval.isOrNull(c, fieldName)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Field field = BeanUtilities.getField(c, fieldName);
            Object oldValue = field.get(obj);
            field.set(obj, newValue);
            return oldValue;
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("field#set class:" + c + ", field:" + fieldName + ", value:" + newValue, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("field#set class:" + c + ", field:" + fieldName + ", value:" + newValue, e);
        }
    }

    public static Field getAccessibleField(Class c, String fieldName) {
        if (Eval.isOrNull(c, fieldName)) {
            throw new NullPointerException("argument is null.");
        }
        Field field = null;
        try {
            field = BeanUtilities.getAccessibleField(c.getField(fieldName));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Constructor getMatchingAccessibleConstructor(Class c) {
        return BeanUtilities.getMatchingAccessibleConstructor(c, new Class[0]);
    }

    public static Constructor getMatchingAccessibleConstructor(Class c, Class[] parameterTypes) {
        if (Eval.isOrNull(c, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Constructor constructor = BeanUtilities.getAccessibleConstructor(c.getConstructor(parameterTypes));
            if (constructor != null) {
                return constructor;
            }
        }
        catch (SecurityException constructor) {
        }
        catch (NoSuchMethodException constructor) {
            // empty catch block
        }
        int paramSize = parameterTypes.length;
        Constructor<?>[] constructors = c.getConstructors();
        int i = 0;
        int size = constructors.length;
        while (i < size) {
            Class<?>[] constructorParams = constructors[i].getParameterTypes();
            int constructorParamSize = constructorParams.length;
            if (constructorParamSize == paramSize) {
                Constructor constructor;
                boolean match = true;
                int n = 0;
                while (n < constructorParamSize) {
                    if (!BeanUtilities.isAssignmentCompatible(constructorParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (constructor = BeanUtilities.getAccessibleConstructor(constructors[i])) != null) {
                    return constructor;
                }
            }
            ++i;
        }
        return null;
    }

    public static Method getMethod(Class c, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        if (Eval.isOrNull(c, methodName, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(Format.format("class:{0}, method:{1}, args:{2,array}", c, methodName, parameterTypes));
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName) {
        return BeanUtilities.getMatchingAccessibleMethod(c, methodName, new Class[0]);
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleMethod(c, methodName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName, Class[] parameterTypes) {
        if (Eval.isOrNull(c, methodName, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Method method = c.getMethod(methodName, parameterTypes);
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return method;
        }
        catch (SecurityException method) {
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        int paramSize = parameterTypes.length;
        Method[] methods = c.getMethods();
        int i = 0;
        int size = methods.length;
        while (i < size) {
            Class<?>[] methodsParams;
            int methodParamSize;
            if (methods[i].getName().equals(methodName) && (methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) == paramSize) {
                Method method;
                boolean match = true;
                int n = 0;
                while (n < methodParamSize) {
                    if (!BeanUtilities.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (method = BeanUtilities.getAccessibleMethod(methods[i])) != null) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    public static Method getMatchingAccessibleSetProperty(Class c, String propertyName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleSetProperty(c, propertyName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleSetProperty(Class c, String propertyName, Class[] parameterTypes) {
        return BeanUtilities.getMatchingAccessibleMethod(c, "set" + BeanUtilities.capitalize(propertyName), parameterTypes);
    }

    public static Method getMatchingAccessibleGetProperty(Class c, String propertyName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleGetProperty(c, propertyName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleGetProperty(Class c, String propertyName, Class[] parameterTypes) {
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, "get" + BeanUtilities.capitalize(propertyName), parameterTypes);
        if (method == null) {
            method = BeanUtilities.getMatchingAccessibleMethod(c, "is" + BeanUtilities.capitalize(propertyName), parameterTypes);
        }
        return method;
    }

    private static boolean isAssignmentCompatible(Class fromType, Class toType) {
        Class parameterWrapperClass;
        if (fromType.isAssignableFrom(toType)) {
            return true;
        }
        if (fromType.isPrimitive() && (parameterWrapperClass = Boxing.boxClass(fromType)) != null) {
            return parameterWrapperClass.equals(toType);
        }
        return false;
    }

    private static Constructor getConstructor(Class c, Class[] parameterTypes) throws InvocationBeansException {
        Constructor constructor = BeanUtilities.getMatchingAccessibleConstructor(c, parameterTypes);
        if (constructor == null) {
            throw new InvocationBeansException(Format.format("class:{0}, args:{1,array}", c, parameterTypes));
        }
        return constructor;
    }

    private static Field getField(Class c, String fieldName) throws InvocationBeansException {
        Field field = BeanUtilities.getAccessibleField(c, fieldName);
        if (field == null) {
            throw new InvocationBeansException("Not Matching field, class:" + c + ", name:" + fieldName);
        }
        return field;
    }

    private static Field getAccessibleField(Field field) {
        if (field == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            return null;
        }
        Class<?> c = field.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return field;
        }
        field = BeanUtilities.getAccessibleFieldFromInterfaceNest(c, field.getName());
        return field;
    }

    private static Field getAccessibleFieldFromInterfaceNest(Class c, String fieldName) {
        Field field = null;
        while (c != null) {
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        field = interfaces[i].getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (field != null || (field = BeanUtilities.getAccessibleFieldFromInterfaceNest(interfaces[i], fieldName)) != null) break;
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        if (field != null) {
            return field;
        }
        return null;
    }

    private static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> c = method.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return method;
        }
        method = BeanUtilities.getAccessibleMethodFromInterfaceNest(c, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Constructor getAccessibleConstructor(Constructor constructor) {
        if (constructor == null) {
            return null;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class c = constructor.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return constructor;
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class c, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (c != null) {
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (method != null || (method = BeanUtilities.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    private static Map getMapPropertyDescriptors(Object bean) {
        HashMap<String, PropertyDescriptor> propsDesc = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] ds = BeanUtilities.getPropertyDescriptors(bean);
        int i = 0;
        while (i < ds.length) {
            propsDesc.put(ds[i].getName(), ds[i]);
            ++i;
        }
        return propsDesc;
    }

    private static Class[] toClassArray(Object[] os) {
        Class[] cs = new Class[os.length];
        int i = 0;
        while (i < os.length) {
            cs[i] = os[i].getClass();
            ++i;
        }
        return cs;
    }

    private static Object[] newParameterValues(Object[] srcValues) throws InvocationBeansException {
        Object[] newValues;
        if (srcValues == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            newValues = new Object[srcValues.length];
            int i = 0;
            while (i < srcValues.length) {
                Object o = srcValues[i];
                if (o instanceof ObjectGenerator) {
                    o = ((ObjectGenerator)o).getInstance();
                }
                newValues[i] = o;
                ++i;
            }
        }
        catch (ObjectCreationException e) {
            if (e.getCause() instanceof InvocationBeansException) {
                throw (InvocationBeansException)e.getCause();
            }
            throw new InvocationBeansException(e);
        }
        return newValues;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

