/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import shohaku.core.beans.ArgumentInfo;
import shohaku.core.beans.FeatureInfo;

public class ArgumentsInfo
extends FeatureInfo {
    private Class[] parameterTypes;
    private Object[] parameterValues;
    private ArgumentInfo[] parameteres;

    public ArgumentsInfo() {
    }

    public ArgumentsInfo(ArgumentInfo[] params) {
        this.setParameteres(params);
    }

    public ArgumentsInfo(Class type, Object value) {
        this.setParameteres(new Class[]{type}, new Object[]{value});
    }

    public ArgumentsInfo(Class[] types, Object[] values) {
        this.setParameteres(types, values);
    }

    public Object[] getParameterValues() {
        return this.parameterValues;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ArgumentInfo[] getParameteres() {
        return this.parameteres;
    }

    public void setParameteres(ArgumentInfo[] params) {
        if (params == null) {
            throw new NullPointerException("argument is null.");
        }
        Class[] types = new Class[params.length];
        Object[] values = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            if (params[i].getType() == null) {
                throw new NullPointerException("argument params[i].types is null.");
            }
            types[i] = params[i].getType();
            values[i] = params[i].getValue();
            ++i;
        }
        this.parameterTypes = types;
        this.parameterValues = values;
        this.parameteres = params;
    }

    public void setParameteres(Class[] types, Object[] values) {
        if (types == null || values == null) {
            throw new NullPointerException("argument is null.");
        }
        if (types.length != values.length) {
            throw new IllegalArgumentException("types.length != values.length.");
        }
        ArgumentInfo[] params = new ArgumentInfo[types.length];
        int i = 0;
        while (i < params.length) {
            if (types[i] == null) {
                throw new NullPointerException("argument params[i].types is null.");
            }
            params[i] = new ArgumentInfo(types[i], values[i]);
            ++i;
        }
        this.parameterTypes = types;
        this.parameterValues = values;
        this.parameteres = params;
    }
}

