/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import junit.framework.TestCase;
import shohaku.core.util.debug.Debug;
import shohaku.core.util.debug.StopWatch;

/**
 * TestFormat
 */
public class TestFormat extends TestCase {

    public class TestBean {
        public List getWeek() {
            return Arrays.asList(new Object[] { "月", "火", "水", "木", "金", "土", "日" });
        }

        public Object getDay(int i) {
            return getWeek().get(i);
        }
        public char getChar(String s, int i) {
            return s.charAt(i);
        }
        
        public String concat(Object o, Object o2, Object o3, char c) {
            return String.valueOf(o) + String.valueOf(o2) + String.valueOf(o3) + c;
        }
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TestFormat.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Constructor for TestFormat.
     * 
     * @param arg0
     */
    public TestFormat(String arg0) {
        super(arg0);
    }

    /*
     * String toString のテスト中のクラス(Object)
     */
    public final void testToStringObject() {
        //TODO toString() を実装します。
    }

    public final void testDeepToString() {
        //TODO deepToString() を実装します。
    }

    public final void testFormat() {
        //format() を実装します。
        HashMap m = new HashMap();
        Object[] a = new Object[] { "配列", "文字列長5", m };
        m.put("test", new TestBean());
        m.put(".arr)\",}ay", a);
        m.put(Boolean.FALSE, a);
        Object[] args = new Object[] { a, m, new TestBean(), ".arr)\",}ay", new Integer(2) };

        //ArrayFormater
        
        StopWatch.out.start();

        //配列
        assertEquals(Format.format("{0,array}", new Object[] { new Object[] { "1", "2" } }), "[1, 2]");
        //配列->1
        assertEquals(Format.format("{0,array,1}", new Object[] { new Object[] { "1", "2" } }), "2");
        //配列長
        assertEquals(Format.format("{0,array,size}", new Object[] { new Object[] { "1", "2" } }), "2");

        //BeansFormater
        //マップ->プロパティ->リスト 文字連結
        assertEquals(Format.format("'{1,bean,get(\"test\").week[3]}', '{1,bean,get(\"test\").week[4]}'", args),
                "'木', '金'");
        //メソッド
        assertEquals(Format.format("{2,bean,getWeek()}", args), "[月, 火, 水, 木, 金, 土, 日]");
        //メソッド->リスト
        assertEquals(Format.format("{2,bean,getWeek()[6]}", args), "日");
        //メソッド
        assertEquals(Format.format("{2,bean,getDay(%4)}", args), "水");
        //メソッド
        assertEquals(Format.format("{2,bean,getDay(3)}", args), "木");
        //メソッド
        assertEquals(Format.format("{2,bean,getChar(\"月\\\"火\",2)}", args), "火");
        //配列->マップ->配列
        assertEquals(Format.format("{0,bean,[2].get(false)[0]}", args), "配列");
        //配列->メソッド->配列
        assertEquals(Format.format("{0,bean,[2].get(false)[0]}", args), "配列");
        //配列->マップ->配列
        assertEquals(Format.format("{0,bean,[2].get(%3)[1]}", args), "文字列長5");
        //配列->マップ->配列->メソッド
        assertEquals(Format.format("{0,bean,[2].get(\".arr)\\\",\\}ay\")[1].length()}", args), "5");
        //プロパティ->リスト 文字連結
        assertEquals(Format.format("{2,bean,week[1]}曜日～{2,bean,week[4]}曜日まで", args), "火曜日～金曜日まで");

        Debug.out.println(Format.format("{0,bean,[2]}", args));
        Debug.out.println(Format.format("{0,bean,[2].get(\".arr)\\\",\\}ay\")}", args));
        
        Debug.out.println(Format.format("{2,bean,concat(|2004-12-13 23:11:19.426|,\"月\\\"火:\",+21234.56D,'\\u0024')}", args));
        
        StopWatch.out.stop();
    }

}
