/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import junit.framework.TestCase;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.debug.Debug;

/**
 * TestELBinder
 */
public class TestCompositeExpressionBinder extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TestCompositeExpressionBinder.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Constructor for TestELBinder.
     * 
     * @param arg0
     */
    public TestCompositeExpressionBinder(String arg0) {
        super(arg0);
    }

    /*
     * void SerialExpressionBinder のテスト中のクラス()
     */
    public final void testELBinder() {
        //TODO SerialExpressionBinder() を実装します。
    }

    /*
     * void SerialExpressionBinder のテスト中のクラス(Locale)
     */
    public final void testELBinderLocale() {
        //TODO SerialExpressionBinder() を実装します。
    }

    /*
     * void SerialExpressionBinder のテスト中のクラス(Locale, Expression[])
     */
    public final void testELBinderLocaleExpressionArray() {
        //TODO SerialExpressionBinder() を実装します。
    }

    public final void testGetExpressions() {
        //TODO getExpressions() を実装します。
    }

    public final void testGetLocale() {
        //TODO getLocale() を実装します。
    }

    public final void testGetValue() {
        //TODO getValue() を実装します。
    }

    public final void testGetBaseTypeCreationBinder() {
        //getBaseTypeCreationBinder()
        CELBinder binder = CELBinder.getBaseTypeCreationBinder();
        Debug.out.printTypeln(binder.getValue("null"));
        //string
        Debug.out.printTypeln(binder.getValue("\"\"A-Z\""));
        Debug.out.printTypeln(binder.getValue("\"'\"\\}^古今東西\""));
        //char
        Debug.out.printTypeln(binder.getValue("'あ'"));
        Debug.out.printTypeln(binder.getValue("'\u0061'"));
        //Regex Pattern
        //Debug.out.printTypeln(binder.getValue("/[a-z]+/"));
        //date
        Debug.out.printTypeln(binder.getValue("|2005|"));
        Debug.out.printTypeln(binder.getValue("|2005-12|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23:14|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23:14:55|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23:14:55.7|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23:14:55.77|"));
        Debug.out.printTypeln(binder.getValue("|2005-12-13 23:14:55.777|"));
        Debug.out.printTypeln(binder.getValue("|23:14|"));
        Debug.out.printTypeln(binder.getValue("|23:14:55|"));
        Debug.out.printTypeln(binder.getValue("|23:14:55.7|"));
        Debug.out.printTypeln(binder.getValue("|23:14:55.77|"));
        Debug.out.printTypeln(binder.getValue("|23:14:55.777|"));
        //number
        Debug.out.printTypeln(binder.getValue("123B"));
        Debug.out.printTypeln(binder.getValue("13213S"));
        Debug.out.printTypeln(binder.getValue("13213I"));
        Debug.out.printTypeln(binder.getValue("13213L"));
        Debug.out.printTypeln(binder.getValue("13213.44F"));
        Debug.out.printTypeln(binder.getValue("13213.44D"));
        Debug.out.printTypeln(binder.getValue("13213"));
        Debug.out.printTypeln(binder.getValue("13213.987"));
        //bool
        Debug.out.printTypeln(binder.getValue("false"));
        Debug.out.printTypeln(binder.getValue("true"));

    }

    public final void testGetObjectCreationBinder() {
        //getObjectCreationBinder()
        CELBinder binder = CELBinder.getObjectCreationBinder();
        Debug.out.printTypeColl((List) binder
                .getValue("[ \"[]\\\"古今東西[\"  , '東', ']', 0X123L,123.234, |2005-12-31| , false   , null]"));
        Debug.out.println();
        Debug.out
                .printTypeColl((Set) binder
                        .getValue("< \"[]\\\"古今東西[\"  , '東', ']', 0X123L,123.234, |2005-12-31| , |2005-12-31| , true,true,false, null>"));
        Debug.out.println();
        Debug.out
                .printTypeMap((Map) binder
                        .getValue("{ \"[]\\\"古今東西[\":'東', ']':0X123L,123.234:|2005-12-31|, \"BOOLEAN\":false,   /^[a-z]*$/:null}"));
        Debug.out.println();

        Debug.out.printTypeln(binder
                .getValue("{ <\"S\",0X123L,123.234>:[|2005-12-31|, true], { 123.234:/^[a-z]*$/ }:123456L }"));
        Debug.out.println();

        Debug.out.println(binder.getValue("@java.util.LinkedList([1,2,true])@"));
        Debug.out.println();
        
        Debug.out.printTypeln(binder.getValue("[@java.util.regex.Pattern#compile(\"[a-wA-Z]+\")@]"));
        Debug.out.println();
        
        Debug.out.printTypeln(binder.getValue("<3, null, @java.util.regex.Pattern#compile(\"[a-wA-Z]+\")@, false, @java.util.LinkedList([1,2,true])@>"));
        Debug.out.println();

    }

}
