/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

import java.util.Arrays;

import junit.framework.TestCase;

/**
 * TestBoxing
 */
public class TestBoxing extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TestBoxing.class);
    }

    /*
     * Class box のテスト中のクラス(Class)
     */
    public final void testBoxingClassClass() {
        //boxClass() を実装します。
        assertEquals(Boxing.boxClass(char.class), Character.class);
        assertEquals(Boxing.boxClass(boolean.class), Boolean.class);
        assertEquals(Boxing.boxClass(byte.class), Byte.class);
        assertEquals(Boxing.boxClass(short.class), Short.class);
        assertEquals(Boxing.boxClass(int.class), Integer.class);
        assertEquals(Boxing.boxClass(long.class), Long.class);
        assertEquals(Boxing.boxClass(float.class), Float.class);
        assertEquals(Boxing.boxClass(double.class), Double.class);
        assertEquals(Boxing.boxClass(void.class), Void.class);

        try {
            Boxing.boxClass(Object.class);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(true);
        }

    }

    /*
     * Class unbox のテスト中のクラス(Class)
     */
    public final void testUnboxClassClass() {
        //unboxClass() を実装します。
        assertEquals(Boxing.unboxClass(Character.class), char.class);
        assertEquals(Boxing.unboxClass(Boolean.class), boolean.class);
        assertEquals(Boxing.unboxClass(Byte.class), byte.class);
        assertEquals(Boxing.unboxClass(Short.class), short.class);
        assertEquals(Boxing.unboxClass(Integer.class), int.class);
        assertEquals(Boxing.unboxClass(Long.class), long.class);
        assertEquals(Boxing.unboxClass(Float.class), float.class);
        assertEquals(Boxing.unboxClass(Double.class), double.class);
        assertEquals(Boxing.unboxClass(Void.class), void.class);

        try {
            Boxing.unboxClass(Object.class);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(true);
        }
    }

    /*
     * char[] unbox のテスト中のクラス(Character[])
     */
    public final void testUnboxCharacterArray() {
        //unbox() を実装します。
        assertTrue(Eval.isEquals(Boxing.unbox(new Character[] { new Character('0'), new Character('1') }), "01"
                .toCharArray()));

        try {
            Boxing.unbox((Character[]) null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }

    /*
     * boolean[] unbox のテスト中のクラス(Boolean[])
     */
    public final void testUnboxBooleanArray() {
        //unbox() を実装します。
        assertTrue(Eval.isEquals(Boxing.unbox(new Boolean[] { Boolean.FALSE, Boolean.TRUE }), new boolean[] { false,
                true }));

        try {
            Boxing.unbox((Boolean[]) null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }

    /*
     * byte[] unbox のテスト中のクラス(Byte[])
     */
    public final void testUnboxByteArray() {
        //unbox() を実装します。
        assertTrue(Eval.isEquals(Boxing.unbox(new Byte[] { new Byte((byte)123), new Byte((byte)22) }), new byte[] { 123, 22 }));

        try {
            Boxing.unbox((Byte[]) null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }

    /*
     * short[] unbox のテスト中のクラス(Short[])
     */
    public final void testUnboxShortArray() {
        //unbox() を実装します。
        assertTrue(Eval.isEquals(Boxing.unbox(new Short[] { new Short((short)123), new Short((short)22) }), new short[] { 123, 22 }));

        try {
            Boxing.unbox((Short[]) null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }

    /*
     * int[] unbox のテスト中のクラス(Integer[])
     */
    public final void testUnboxIntegerArray() {
//      unbox() を実装します。
        assertTrue(Eval.isEquals(Boxing.unbox(new Integer[] { new Integer(123), new Integer(22) }), new int[] { 123, 22 }));

        try {
            Boxing.unbox((Integer[]) null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }

    /*
     * long[] unbox のテスト中のクラス(Long[])
     */
    public final void testUnboxLongArray() {
        //TODO unbox() を実装します。
    }

    /*
     * float[] unbox のテスト中のクラス(Float[])
     */
    public final void testUnboxFloatArray() {
        //TODO unbox() を実装します。
    }

    /*
     * double[] unbox のテスト中のクラス(Double[])
     */
    public final void testUnboxDoubleArray() {
        //TODO unbox() を実装します。
    }

    /*
     * Character[] box のテスト中のクラス(char[])
     */
    public final void testBoxingcharArray() {
        //TODO box() を実装します。
    }

    /*
     * Boolean[] box のテスト中のクラス(boolean[])
     */
    public final void testBoxingbooleanArray() {
        //TODO box() を実装します。
    }

    /*
     * Byte[] box のテスト中のクラス(byte[])
     */
    public final void testBoxingbyteArray() {
        //TODO box() を実装します。
    }

    /*
     * Short[] box のテスト中のクラス(short[])
     */
    public final void testBoxingshortArray() {
        //TODO box() を実装します。
    }

    /*
     * Integer[] box のテスト中のクラス(int[])
     */
    public final void testBoxingintArray() {
        //TODO box() を実装します。
    }

    /*
     * Long[] box のテスト中のクラス(long[])
     */
    public final void testBoxinglongArray() {
        //TODO box() を実装します。
    }

    /*
     * Float[] box のテスト中のクラス(float[])
     */
    public final void testBoxingfloatArray() {
        //TODO box() を実装します。
    }

    /*
     * Double[] box のテスト中のクラス(double[])
     */
    public final void testBoxingdoubleArray() {
        //TODO box() を実装します。
    }

    /*
     * List asList のテスト中のクラス(Object)
     */
    public final void testAsListObject() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(char[])
     */
    public final void testAsListcharArray() {
        //asList() を実装します。
        assertEquals(Boxing.asList(new char[] { 'a', 'b', 'c' }), Arrays.asList(new Character[] { new Character('a'),
                new Character('b'), new Character('c') }));
        assertEquals(Boxing.asList(new char[] {}), Arrays.asList(new Character[] {}));
    }

    /*
     * List asList のテスト中のクラス(boolean[])
     */
    public final void testAsListbooleanArray() {
        //asList() を実装します。
        assertEquals(Boxing.asList(new boolean[] { false, true, true }), Arrays.asList(new Boolean[] { Boolean.FALSE,
                Boolean.TRUE, Boolean.TRUE }));
        assertEquals(Boxing.asList(new boolean[] {}), Arrays.asList(new Boolean[] {}));
    }

    /*
     * List asList のテスト中のクラス(byte[])
     */
    public final void testAsListbyteArray() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(short[])
     */
    public final void testAsListshortArray() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(int[])
     */
    public final void testAsListintArray() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(long[])
     */
    public final void testAsListlongArray() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(float[])
     */
    public final void testAsListfloatArray() {
        //TODO asList() を実装します。
    }

    /*
     * List asList のテスト中のクラス(double[])
     */
    public final void testAsListdoubleArray() {
        //TODO asList() を実装します。
    }

}
