/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

/**
 * 数値型のユーティリティメソッドを提供します。
 */
public class DecimalUtils {

    /*
     * parse
     */

    /**
     * 文字列を引数で指定される書式に応じた数値型に変換します。 変換に失敗した場合NULLを返す。
     * 
     * @param text
     *            文字列
     * @param pattern
     *            書式
     * @return 変換後の文字列
     */
    public static Number parse(String text, String pattern) {
        try {
            NumberFormat format = new DecimalFormat(pattern);
            return format.parse(text);
        } catch (ParseException ex) {
            return null;
        }
    }

    /*
     * format
     */

    /**
     * 数値(long)を引数で指定される書式に変換します。
     * 
     * @param number
     *            数値
     * @param pattern
     *            書式
     * @return 変換後の文字列
     */
    public static String format(long number, String pattern) {
        NumberFormat format = new DecimalFormat(pattern);
        return format.format(number);
    }

    /**
     * 数値(double)を引数で指定される書式に変換します。
     * 
     * @param number
     *            数値
     * @param pattern
     *            書式
     * @return 変換後の文字列
     */
    public static String format(double number, String pattern) {
        NumberFormat format = new DecimalFormat(pattern);
        return format.format(number);
    }
}
