/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.collections.wrapper;

import java.io.Serializable;
import java.util.Set;

/**
 * 指定されたセットの変更不可能なビューを定義します。 <br>
 * <br>
 * このクラスは <code>java.util.Collections#unmodifiableSet(Set)</code> で返されるクラスとほぼ同等の仕様です。 <br>
 */
public class UnmodifiableSet extends UnmodifiableCollection implements Set, Serializable {

    /** 基となるセット。 */
    protected final Set set;

    /**
     * ラップするセットを指定して初期化します。
     * 
     * @param s
     *            ラップするセット
     */
    public UnmodifiableSet(Set s) {
        super(s);
        this.set = s;
    }

    /**
     * 基となるセットの同メソッドを呼び出します。
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object o) {
        return set.equals(o);
    }

    /**
     * 基となるセットの同メソッドを呼び出します。
     * 
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return set.hashCode();
    }
}