/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.collections;

import java.lang.reflect.Array;

/**
 * 配列のユーティリティメソッドを提供します。
 */
public class ArraysUtils {

    /*
     * Search
     */

    /*
     * new instance
     */

    /**
     * 引数 <code>a</code> のクラス型の配列インスタンスを同じ配列数で生成して返します。
     * 
     * @param a
     *            生成する配列のクラス型を示す配列
     * @return 配列インスタンス
     * @throws NullPointerException
     *             <code>a</code> に <code>null</code> が指定された場合
     */
    public static Object[] newInstance(Object[] a) {
        if (a == null) {
            throw new NullPointerException("a is null.");
        }
        return newInstance(a, a.length);
    }

    /**
     * 引数 <code>a</code> のクラス型の配列インスタンスを指定の配列数で生成して返します。
     * 
     * @param a
     *            生成する配列のクラス型を示す配列
     * @param length
     *            配列数
     * @return 配列インスタンス
     * @throws NullPointerException
     *             <code>a</code> に <code>null</code> が指定された場合
     * @throws NegativeArraySizeException
     *             指定された <code>length</code> が負の場合
     */
    public static Object[] newInstance(Object[] a, int length) {
        if (a == null) {
            throw new NullPointerException("a is null.");
        }
        return (Object[]) Array.newInstance(a.getClass().getComponentType(), length);
    }

}
