/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.beans;

/**
 * コンストラクタ又はファクトリメソッドの情報を格納しオブジェクトを生成する機能を提供します。 <br>
 * <br>
 * この機能はコンストラクタとファクトリメソッドの情報を同等に扱います。 <br>
 * その為、生成基のクラスと生成されるオブジェクトは同一とは限りません。
 */
public class FactoryMethodInfo extends MethodFeatureInfo {

    /**
     * デフォルトコンストラクタ。
     */
    public FactoryMethodInfo() {
        //no op
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param params
     *            パラメータ情報のリスト
     */
    public FactoryMethodInfo(ParametersInfo params) {
        setParameteres(params);
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param params
     *            パラメータ情報のリスト
     * @param factoryType
     *            生成基のオブジェクト型
     */
    public FactoryMethodInfo(ParametersInfo params, Class factoryType) {
        setParameteres(params);
        setObjectType(factoryType);
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param methodName
     *            メソッド名
     * @param params
     *            パラメータ情報のリスト
     */
    public FactoryMethodInfo(String methodName, ParametersInfo params) {
        setMethodName(methodName);
        setParameteres(params);
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param methodName
     *            メソッド名
     * @param params
     *            パラメータ情報のリスト
     * @param factoryType
     *            生成基のオブジェクト型
     */
    public FactoryMethodInfo(String methodName, ParametersInfo params, Class factoryType) {
        setMethodName(methodName);
        setParameteres(params);
        setObjectType(factoryType);
    }

}
