/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans;

import java.lang.reflect.Method;

import shohaku.core.collections.Parameters;

/**
 * メソッドを更新規則と名前で拘束されたパラメータで関連づける機能を提供します。 <br>
 * このインターフェースの実装は普遍オブジェクトである必要があります。
 */
public interface BindMethod {

    /** パラメータ拘束規則：固定の値。 */
    static final int BIND_RULE_FINAL = 0;

    /** パラメータ拘束規則：上書き可能な値。 */
    static final int BIND_RULE_OVERWRITE = 1;

    /** パラメータ拘束規則：実行時に指定。 */
    static final int BIND_RULE_REQUIRED = 2;

    /**
     * メソッドを呼び出し結果を返します。
     * 
     * @param values
     *            引数名で拘束されるメソッドの引数値
     * @return メソッドの戻り値
     * @throws InvocationBeansException
     *             処理の呼出に失敗した場合発生する
     */
    Object invoke(Parameters values) throws InvocationBeansException;

    /**
     * 実行基のオブジェクト型を返却します。
     * 
     * @return 実行基のオブジェクト型
     */
    Class getObjectType();

    /**
     * メソッド名を返却します。
     * 
     * @return メソッド名
     */
    String getMethodName();

    /**
     * 実行基のオブジェクトを返却します。 <br>
     * メソッドがスタティックの場合は null が有り得ます。
     * 
     * @return 実行基のオブジェクト
     */
    Object getSrcObject();

    /**
     * メソッドを返却します。
     * 
     * @return メソッド
     */
    Method getMethod();

}
