/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.debug;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StopWatch {
    public static final StopWatch out = new StopWatch(System.out);
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private final PrintWriter writer;
    private int runningState = 0;
    private String timeFormat = "HH:mm:ss.SSS";
    private long startTime = -1L;
    private long stopTime = -1L;
    private long splitTime = -1L;

    public StopWatch() {
        this(System.out);
    }

    public StopWatch(PrintStream pstream) {
        this(new PrintWriter(pstream, true));
    }

    public StopWatch(PrintWriter writer) {
        this.writer = writer;
    }

    public long start() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this.runningState == 2) {
                throw new IllegalStateException("Timer must be reset before being restarted. ");
            }
            if (this.runningState != 0) {
                throw new IllegalStateException("Timer already started. ");
            }
            this.stopTime = -1L;
            this.splitTime = this.startTime = System.currentTimeMillis();
            this.printDate("start", this.startTime);
            this.runningState = 1;
            return this.startTime;
        }
    }

    public long time() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            long time = System.currentTimeMillis() - this.startTime;
            this.printTimeMillis("time ", time);
            return time;
        }
    }

    public long split() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this.runningState != 1) {
                throw new IllegalStateException("Timer is not running. ");
            }
            long psplit = this.splitTime;
            this.splitTime = System.currentTimeMillis();
            long time = this.splitTime - psplit;
            this.printTimeMillis("split", time);
            return time;
        }
    }

    public long stop() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this.runningState != 1 && this.runningState != 3) {
                throw new IllegalStateException("Timer is not running. ");
            }
            long start = this.startTime;
            long end = System.currentTimeMillis();
            long time = end - start;
            this.printDate("stop ", end);
            if (start < this.splitTime) {
                this.printTimeMillis("split", end - this.splitTime);
            }
            this.printTimeMillis("time ", time);
            this.startTime = -1L;
            this.stopTime = -1L;
            this.splitTime = -1L;
            this.runningState = 2;
            return time;
        }
    }

    public void suspend() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this.runningState != 1) {
                throw new IllegalStateException("Timer must be running to suspend. ");
            }
            this.stopTime = System.currentTimeMillis();
            this.runningState = 3;
        }
    }

    public void resume() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this.runningState != 3) {
                throw new IllegalStateException("Timer must be suspended to resume. ");
            }
            this.startTime += System.currentTimeMillis() - this.stopTime;
            this.stopTime = -1L;
            this.runningState = 1;
        }
    }

    public long currentTime() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            long time = System.currentTimeMillis();
            this.printDate("time ", time);
            return time;
        }
    }

    public void reset() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            this.runningState = 0;
            this.startTime = -1L;
            this.stopTime = -1L;
            this.splitTime = -1L;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Timer{");
        sb.append("start=");
        sb.append(this.startTime);
        sb.append(", ");
        sb.append("stop=");
        sb.append(this.stopTime);
        sb.append(", ");
        sb.append("split=");
        sb.append(this.splitTime);
        sb.append("}");
        return sb.toString();
    }

    public String getTimeFormat() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            return this.timeFormat;
        }
    }

    public void setTimeFormat(String timeFormat) {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            this.timeFormat = timeFormat;
        }
    }

    private void printTimeMillis(Object title, long time) {
        this.writer.print(title);
        this.writer.print(" : ");
        this.writer.print(time);
        this.writer.println();
    }

    private void printDate(Object title, long time) {
        this.writer.print(title);
        this.writer.print(" : ");
        this.writer.print(this.formatDate(new Date(time)));
        this.writer.println();
    }

    private String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat);
        return formatter.format(date);
    }
}

