/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.LinkedHashMap;
import shohaku.core.collections.Parameters;
import shohaku.core.lang.Seek;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.Expression;
import shohaku.core.util.cel.Literal;

public class MapExpression
implements Expression {
    private static final Literal[] literals = new Literal[]{new Literal('{', '}')};

    public Literal[] getLiteral() {
        return literals;
    }

    public Object execute(CELBinder binder, Literal literal, String expression, int begin, int end, Parameters values) {
        String exp = expression.substring(begin, end).trim();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int i = 0;
        while (i < exp.length()) {
            Object key = null;
            Object value = null;
            int kinx = binder.findNextIndex(exp, i);
            if (kinx < 0) break;
            key = binder.getValue(exp, i, kinx, values);
            i = Seek.skipTo((CharSequence)exp, ' ', kinx);
            if (i >= exp.length()) {
                throw new IllegalArgumentException();
            }
            if (':' != exp.charAt(i)) {
                throw new IllegalArgumentException();
            }
            int vinx = binder.findNextIndex(exp, i = Seek.skipTo((CharSequence)exp, ' ', i + 1));
            if (vinx < 0) {
                throw new IllegalArgumentException();
            }
            value = binder.getValue(exp, i, vinx, values);
            i = Seek.skipTo((CharSequence)exp, ' ', vinx);
            if (i >= exp.length()) {
                map.put(key, value);
                break;
            }
            if (',' != exp.charAt(i)) {
                throw new IllegalArgumentException();
            }
            i = Seek.skipTo((CharSequence)exp, ' ', i + 1);
            map.put(key, value);
        }
        return map;
    }

    public int findNextIndex(CELBinder binder, Literal literal, String expression, int begin) {
        int end = begin + 1;
        end = Seek.skipTo((CharSequence)expression, ' ', end);
        while (end < expression.length()) {
            if (-1 == (end = binder.findNextIndex(expression, end))) {
                return -1;
            }
            end = Seek.skipTo((CharSequence)expression, new char[]{':', ' '}, end);
            if (-1 == (end = binder.findNextIndex(expression, end))) {
                return -1;
            }
            char c = expression.charAt(end = Seek.skipTo((CharSequence)expression, new char[]{',', ' '}, end));
            if (c == '}') break;
        }
        return end + 1;
    }
}

