/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import java.util.Date;
import shohaku.core.collections.Parameters;
import shohaku.core.util.DateUtils;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.Expression;
import shohaku.core.util.cel.Literal;

public class DateTimeExpression
implements Expression {
    private static final String[] dateFormats;
    private static final Literal[] literals;

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("yyyy");
        list.add("yyyy-MM");
        list.add("yyyy-MM-dd");
        list.add("yyyy-MM-dd HH");
        list.add("yyyy-MM-dd HH:mm");
        list.add("yyyy-MM-dd HH:mm:ss");
        list.add("yyyy-MM-dd HH:mm:ss.S");
        list.add("yyyy-MM-dd HH:mm:ss.SS");
        list.add("yyyy-MM-dd HH:mm:ss.SSS");
        list.add("HH:mm");
        list.add("HH:mm:ss");
        list.add("HH:mm:ss.S");
        list.add("HH:mm:ss.SS");
        list.add("HH:mm:ss.SSS");
        dateFormats = list.toArray(new String[0]);
        literals = new Literal[]{new Literal('|', '|')};
    }

    public Literal[] getLiteral() {
        return literals;
    }

    public Object execute(CELBinder binder, Literal literal, String expression, int begin, int end, Parameters values) {
        Date d = DateUtils.parse(expression.substring(begin, end), dateFormats);
        if (d == null) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    public int findNextIndex(CELBinder binder, Literal literal, String expression, int begin) {
        int end = begin + 1;
        while (end < expression.length()) {
            if (-1 == (end = expression.indexOf(124, end))) {
                return -1;
            }
            if (end == 0 || end > 0 && '\\' != expression.charAt(end - 1)) break;
            ++end;
        }
        return end + 1;
    }
}

