/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.lang.reflect.Array;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.lang.Eval;
import shohaku.core.lang.Seek;
import shohaku.core.util.ToStringHelper;

public class MessageFormatBinder {
    private static final Pattern formatPattern;
    private static final Pattern bracePattern;
    private static final Formater[] defaultFormaters;
    private static final MessageFormatBinder defaultBinder;
    private final Map formaterMap;
    private final Formater[] formaters;
    private final Locale locale;

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("\\{");
        sb.append("(\\d+)");
        sb.append("(?:,([_a-z-A-Z]\\w+))?");
        sb.append("(?:,((?>\\\\}|[^}])+))?");
        sb.append("\\}");
        formatPattern = Pattern.compile(sb.toString());
        bracePattern = Pattern.compile("\\\\}");
        ArrayList<Formater> fs = new ArrayList<Formater>();
        fs.add(new BeansFormater());
        fs.add(new CollectionFormater());
        fs.add(new ListFormater());
        fs.add(new SetFormater());
        fs.add(new MapFormater());
        fs.add(new ArrayFormater());
        fs.add(new NumberFormater());
        fs.add(new DateFormater());
        fs.add(new TimeFormater());
        fs.add(new ChoiceFormater());
        defaultFormaters = fs.toArray(new Formater[0]);
        defaultBinder = new MessageFormatBinder();
    }

    public MessageFormatBinder() {
        this(Locale.getDefault(), defaultFormaters);
    }

    public MessageFormatBinder(Locale locale) {
        this(locale, defaultFormaters);
    }

    public MessageFormatBinder(Locale locale, Formater[] fs) {
        this(locale, fs, MessageFormatBinder.toMappingFormaters(fs));
    }

    private MessageFormatBinder(Locale locale, Formater[] fs, Map fsm) {
        this.formaters = fs;
        this.locale = locale;
        this.formaterMap = fsm;
    }

    public Formater[] getFormaters() {
        return (Formater[])this.formaters.clone();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String format(String pattern, Object[] args) {
        StringBuffer sb = new StringBuffer();
        Matcher m = formatPattern.matcher(pattern);
        int i = 0;
        while (i < pattern.length()) {
            if (m.find(i)) {
                sb.append(pattern.substring(i, m.start()));
                String[] sa = new String[3];
                int j = 0;
                while (j < m.groupCount()) {
                    sa[j] = m.group(j + 1);
                    ++j;
                }
                this.formatString(sb, sa[1], this.replaceBrace(sa[2]), args[this.getIndex(sa[0])], args);
                i = m.end();
                continue;
            }
            sb.append(pattern.substring(i));
            break;
        }
        return sb.toString();
    }

    private int getIndex(String sindex) {
        return Integer.parseInt(sindex);
    }

    private String replaceBrace(String sbrace) {
        return sbrace != null ? bracePattern.matcher(sbrace).replaceAll("}") : null;
    }

    private void formatString(StringBuffer sb, String id, String arg, Object value, Object[] values) {
        if (value == null) {
            sb.append("null");
            return;
        }
        if (!Eval.isBlank(id)) {
            Formater f = (Formater)this.formaterMap.get(id);
            sb.append((Object)f.format(this.locale, id, arg, value, values));
        } else {
            sb.append(value);
        }
    }

    public static MessageFormatBinder getDefaultBinder() {
        return defaultBinder;
    }

    private static Map toMappingFormaters(Formater[] fs) {
        HashMap<String, Formater> m = new HashMap<String, Formater>((int)((double)fs.length * 1.5));
        int i = 0;
        while (i < fs.length) {
            String[] ids = fs[i].getIds();
            int j = 0;
            while (j < ids.length) {
                m.put(ids[j], fs[i]);
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableMap(m);
    }

    public interface Formater {
        public String[] getIds();

        public CharSequence format(Locale var1, String var2, String var3, Object var4, Object[] var5);
    }

    private static final class BeansFormater
    implements Formater {
        BeansFormater() {
        }

        public String[] getIds() {
            return new String[]{"bean"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            try {
                if (!Eval.isBlank(arg)) {
                    Object ret = BeanUtilities.getNestedProperty(value, arg.trim(), values);
                    return ToStringHelper.toString(ret, 0);
                }
                return BeanUtilities.toBeanString(value);
            }
            catch (InvocationBeansException e) {
                throw new IllegalArgumentException("id:" + id + ", arg:" + arg);
            }
        }
    }

    private static final class CollectionFormater
    implements Formater {
        CollectionFormater() {
        }

        public String[] getIds() {
            return new String[]{"coll"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("no Collection type:" + value);
            }
            if (!Eval.isBlank(arg)) {
                if ("class".equalsIgnoreCase(arg)) {
                    return ToStringHelper.toString(value, 1);
                }
                if ("deep".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 0);
                }
                if ("detail".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 1);
                }
                if ("size".equalsIgnoreCase(arg)) {
                    return String.valueOf(((Collection)value).size());
                }
                throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
            }
            return ToStringHelper.toString(value, 0);
        }
    }

    private static final class ListFormater
    implements Formater {
        ListFormater() {
        }

        public String[] getIds() {
            return new String[]{"list"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("no List type:" + value);
            }
            if (!Eval.isBlank(arg)) {
                if ("class".equalsIgnoreCase(arg)) {
                    return ToStringHelper.toString(value, 1);
                }
                if ("deep".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 0);
                }
                if ("detail".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 1);
                }
                if ("size".equalsIgnoreCase(arg)) {
                    return String.valueOf(((List)value).size());
                }
                try {
                    int index = Integer.parseInt(arg);
                    return ToStringHelper.toString(((List)value).get(index), 0);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
                }
            }
            return ToStringHelper.toString(value, 0);
        }
    }

    private static final class SetFormater
    implements Formater {
        SetFormater() {
        }

        public String[] getIds() {
            return new String[]{"set"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            if (!(value instanceof Set)) {
                throw new IllegalArgumentException("no Set type:" + value);
            }
            if (!Eval.isBlank(arg)) {
                if ("class".equalsIgnoreCase(arg)) {
                    return ToStringHelper.toString(value, 1);
                }
                if ("deep".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 0);
                }
                if ("detail".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 1);
                }
                if ("size".equalsIgnoreCase(arg)) {
                    return String.valueOf(((Set)value).size());
                }
                throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
            }
            return ToStringHelper.toString(value, 0);
        }
    }

    private static final class MapFormater
    implements Formater {
        MapFormater() {
        }

        public String[] getIds() {
            return new String[]{"map"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException("no Map type:" + value);
            }
            if (!Eval.isBlank(arg)) {
                if ("class".equalsIgnoreCase(arg)) {
                    return ToStringHelper.toString(value, 1);
                }
                if ("deep".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 0);
                }
                if ("detail".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 1);
                }
                if ("size".equalsIgnoreCase(arg)) {
                    return String.valueOf(((Map)value).size());
                }
                if ("get{".startsWith(arg) && '}' == arg.charAt(arg.length() - 1)) {
                    try {
                        int index = Integer.parseInt(arg.substring(4, arg.length() - 1));
                        Object e = ((Map)value).get(values[index]);
                        return ToStringHelper.toString(e, 0);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
                    }
                }
                if ("get[".startsWith(arg) && ']' == arg.charAt(arg.length() - 1)) {
                    try {
                        String key = arg.substring(4, arg.length() - 1);
                        Object e = ((Map)value).get(key);
                        return ToStringHelper.toString(e, 0);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
                    }
                }
                throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
            }
            return ToStringHelper.toString(value, 0);
        }
    }

    private static final class ArrayFormater
    implements Formater {
        ArrayFormater() {
        }

        public String[] getIds() {
            return new String[]{"array"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            if (!value.getClass().isArray()) {
                throw new IllegalArgumentException("no Array type:" + value);
            }
            if (!Eval.isBlank(arg)) {
                if ("class".equalsIgnoreCase(arg)) {
                    return ToStringHelper.toString(value, 1);
                }
                if ("deep".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 0);
                }
                if ("detail".equalsIgnoreCase(arg)) {
                    return ToStringHelper.deepToString(value, 1);
                }
                if ("size".equalsIgnoreCase(arg)) {
                    return String.valueOf(Array.getLength(value));
                }
                try {
                    int index = Integer.parseInt(arg);
                    return ToStringHelper.toString(Array.get(value, index), 0);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unsupported id:" + id + ", arg:" + arg);
                }
            }
            return ToStringHelper.toString(value, 0);
        }
    }

    private static final class NumberFormater
    implements Formater {
        String[] keyword = new String[]{"default", "currency", "percent", "integer"};

        NumberFormater() {
        }

        public String[] getIds() {
            return new String[]{"number"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            NumberFormat newFormat = null;
            if (Eval.isBlank(arg = arg.trim().toLowerCase())) {
                switch (Seek.indexOf(this.keyword, (Object)arg, 0, this.keyword.length)) {
                    case 0: {
                        newFormat = NumberFormat.getInstance(locale);
                        break;
                    }
                    case 1: {
                        newFormat = NumberFormat.getCurrencyInstance(locale);
                        break;
                    }
                    case 2: {
                        newFormat = NumberFormat.getPercentInstance(locale);
                        break;
                    }
                    case 3: {
                        newFormat = NumberFormat.getIntegerInstance(locale);
                        break;
                    }
                    default: {
                        newFormat = new DecimalFormat(arg, new DecimalFormatSymbols(locale));
                        break;
                    }
                }
            } else {
                newFormat = NumberFormat.getInstance(locale);
            }
            return newFormat.format(value);
        }
    }

    private static final class DateFormater
    implements Formater {
        String[] keyword = new String[]{"default", "short", "medium", "long", "full"};

        DateFormater() {
        }

        public String[] getIds() {
            return new String[]{"date"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            Date date = null;
            if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof Calendar) {
                date = ((Calendar)value).getTime();
            } else {
                throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
            }
            DateFormat newFormat = null;
            arg = arg.trim().toLowerCase();
            if (Eval.isBlank(arg)) {
                switch (Seek.indexOf(this.keyword, (Object)arg, 0, this.keyword.length)) {
                    case 0: {
                        newFormat = DateFormat.getDateInstance(2, locale);
                        break;
                    }
                    case 1: {
                        newFormat = DateFormat.getDateInstance(3, locale);
                        break;
                    }
                    case 2: {
                        newFormat = DateFormat.getDateInstance(2, locale);
                        break;
                    }
                    case 3: {
                        newFormat = DateFormat.getDateInstance(1, locale);
                        break;
                    }
                    case 4: {
                        newFormat = DateFormat.getDateInstance(0, locale);
                        break;
                    }
                    default: {
                        newFormat = new SimpleDateFormat(arg, locale);
                        break;
                    }
                }
            } else {
                newFormat = DateFormat.getDateInstance(2, locale);
            }
            return newFormat.format((Object)date);
        }
    }

    private static final class TimeFormater
    implements Formater {
        String[] keyword = new String[]{"default", "short", "medium", "long", "full"};

        TimeFormater() {
        }

        public String[] getIds() {
            return new String[]{"time"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            Date date = null;
            if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof Calendar) {
                date = ((Calendar)value).getTime();
            } else {
                throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
            }
            DateFormat newFormat = null;
            arg = arg.trim().toLowerCase();
            if (Eval.isBlank(arg)) {
                switch (Seek.indexOf(this.keyword, (Object)arg, 0, this.keyword.length)) {
                    case 0: {
                        newFormat = DateFormat.getTimeInstance(2, locale);
                        break;
                    }
                    case 1: {
                        newFormat = DateFormat.getTimeInstance(3, locale);
                        break;
                    }
                    case 2: {
                        newFormat = DateFormat.getTimeInstance(2, locale);
                        break;
                    }
                    case 3: {
                        newFormat = DateFormat.getTimeInstance(1, locale);
                        break;
                    }
                    case 4: {
                        newFormat = DateFormat.getTimeInstance(0, locale);
                        break;
                    }
                    default: {
                        newFormat = new SimpleDateFormat(arg, locale);
                        break;
                    }
                }
            } else {
                newFormat = DateFormat.getDateInstance(2, locale);
            }
            return newFormat.format((Object)date);
        }
    }

    private static final class ChoiceFormater
    implements Formater {
        ChoiceFormater() {
        }

        public String[] getIds() {
            return new String[]{"choice"};
        }

        public CharSequence format(Locale locale, String id, String arg, Object value, Object[] values) {
            ChoiceFormat newFormat = null;
            try {
                newFormat = new ChoiceFormat(arg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Choice Pattern incorrect");
            }
            return newFormat.format(value);
        }
    }
}

