/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import shohaku.core.collections.Group;
import shohaku.core.lang.Seek;

public class Eval {
    public static boolean isBlank(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEndBlank(CharSequence cs1, CharSequence cs2) {
        return !(cs1 != null && cs1.length() != 0 || cs2 != null && cs2.length() != 0);
    }

    public static boolean isEndBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            CharSequence cs = css[i];
            if (cs != null && cs.length() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrBlank(CharSequence cs1, CharSequence cs2) {
        return cs1 == null || cs1.length() == 0 || cs2 == null || cs2.length() == 0;
    }

    public static boolean isOrBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            CharSequence cs = css[i];
            if (cs == null || cs.length() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(Object[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Group g) {
        return g == null || g.isEmpty();
    }

    public static boolean isEndNull(Object o1, Object o2) {
        return o1 == null && o2 == null;
    }

    public static boolean isEndNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    public static boolean isOrNull(Object o1, Object o2, Object o3) {
        return o1 == null || o2 == null || o3 == null;
    }

    public static boolean isOrNull(Object o1, Object o2, Object o3, Object o4) {
        return o1 == null || o2 == null || o3 == null || o4 == null;
    }

    public static boolean isOrNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLength(CharSequence a, int length) {
        if (a == null) {
            return false;
        }
        return a.length() == length;
    }

    public static boolean isLength(CharSequence a, int min, int max) {
        if (a == null) {
            return false;
        }
        return Eval.isRange(a.length(), min, max);
    }

    public static boolean isArrayLength(Object a, int length) {
        if (a == null) {
            return false;
        }
        return Array.getLength(a) == length;
    }

    public static boolean isArrayIndex(Object a, int index) {
        if (a == null) {
            return false;
        }
        int length = Array.getLength(a);
        return index >= 0 && index < length;
    }

    public static boolean isArrayIndex(Object a, int fromIndex, int toIndex) {
        if (a == null) {
            return false;
        }
        int length = Array.getLength(a);
        return fromIndex >= 0 && fromIndex < length && toIndex >= 0 && toIndex < length && fromIndex <= toIndex;
    }

    public static boolean isEqualsLength(Object[] as) {
        if (Eval.isEmpty(as)) {
            throw new IllegalArgumentException("array as empty");
        }
        if (Eval.isOrNull(as)) {
            return false;
        }
        int l = Array.getLength(as[0]);
        int i = 1;
        while (i < as.length) {
            if (l != Array.getLength(as[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(boolean[] a, boolean[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(int[] a, int[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(long[] a, long[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!Eval.isEquals(a[i], a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(Object o, Object o2) {
        if (o == o2) {
            return true;
        }
        return o != null && o.equals(o2);
    }

    public static boolean isEndEquals(Object o, Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (!Eval.isEquals(o, os[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrEquals(Object o, Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (Eval.isEquals(o, os[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrSuffix(CharSequence cs, char[] suffixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        char suffix = cs.charAt(cs.length() - 1);
        int i = 0;
        while (i < suffixs.length) {
            if (suffix == suffixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrSuffix(CharSequence cs, CharSequence[] suffixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        int i = 0;
        while (i < suffixs.length) {
            if (Eval.startsWith(cs, suffixs[i], cs.length() - suffixs[i].length())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isStartsWith(CharSequence cs, CharSequence prefix, int offset) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        return Eval.startsWith(cs, prefix, offset);
    }

    public static boolean isOrPrefix(CharSequence cs, char[] prefixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        char prefix = cs.charAt(0);
        int i = 0;
        while (i < prefixs.length) {
            if (prefix == prefixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrPrefix(CharSequence cs, CharSequence[] prefixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        int i = 0;
        while (i < prefixs.length) {
            if (Eval.startsWith(cs, prefixs[i], 0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean startsWith(CharSequence cs, CharSequence prefix, int offset) {
        int plen = prefix.length();
        if (offset < 0 || offset > cs.length() - plen) {
            return false;
        }
        int to = offset;
        int po = 0;
        while (--plen >= 0) {
            if (cs.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRange(char c, char from, char to) {
        return from <= c && c <= to;
    }

    public static boolean isRange(CharSequence cs, char from, char to) {
        int len = cs.length();
        int i = 0;
        while (i < len) {
            char c = cs.charAt(i);
            if (from > c || c > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(CharSequence cs, int length, char from, char to) {
        int len = cs.length();
        if (len != length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c = cs.charAt(i);
            if (from > c || c > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(CharSequence cs, int min, int max, char from, char to) {
        int len = cs.length();
        if (!Eval.isRange(len, min, max)) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c = cs.charAt(i);
            if (from > c || c > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(List list, int index) {
        return index >= 0 && index <= list.size() - 1;
    }

    public static boolean isRange(Object array, int index) {
        return index >= 0 && index <= Array.getLength(array) - 1;
    }

    public static boolean isRange(int i, int from, int to) {
        return from <= i && i <= to;
    }

    public static boolean isRange(long i, long from, long to) {
        return from <= i && i <= to;
    }

    public static boolean isRange(double i, double from, double to) {
        return from <= i && i <= to;
    }

    public static boolean isRange(byte[] a, byte from, byte to) {
        int i = 0;
        while (i < a.length) {
            byte n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(short[] a, short from, short to) {
        int i = 0;
        while (i < a.length) {
            short n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(int[] a, int from, int to) {
        int i = 0;
        while (i < a.length) {
            int n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(long[] a, long from, long to) {
        int i = 0;
        while (i < a.length) {
            long n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(float[] a, float from, float to) {
        int i = 0;
        while (i < a.length) {
            float n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRange(double[] a, double from, double to) {
        int i = 0;
        while (i < a.length) {
            double n = a[i];
            if (from > n && n > to) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAndInstanceOf(Object o, Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            if (!c.isInstance(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrInstanceOf(Object o, Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            if (c.isInstance(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTypeOf(Object o, Class c) {
        return o != null && o.getClass().equals(c);
    }

    public static boolean isComponentTypeOf(Object a, Class c) {
        if (a == null) {
            return false;
        }
        Class<?> type = a.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException("is not Array");
        }
        return type.getComponentType().equals(c);
    }

    public static boolean isContains(Object[] a, Object o) {
        if (a == null) {
            return false;
        }
        return -1 < Seek.indexOf(a, o, 0, a.length);
    }

    public static boolean isContains(Collection c, Object o) {
        if (c == null) {
            return false;
        }
        return c.contains(o);
    }

    public static boolean isContains(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        if (cs instanceof String) {
            return ((String)cs).indexOf(c) >= 0;
        }
        int len = cs.length();
        int i = 0;
        while (i < len) {
            if (cs.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(CharSequence cs, String str) {
        if (cs == null) {
            return false;
        }
        if (cs instanceof String) {
            return ((String)cs).indexOf(str) >= 0;
        }
        if (cs instanceof StringBuffer) {
            return ((StringBuffer)cs).indexOf(str) >= 0;
        }
        return Eval.indexOf(cs, str.toCharArray()) >= 0;
    }

    private static int indexOf(CharSequence source, char[] target) {
        int i = 0;
        int max = source.length();
        int targetCount = target.length;
        if (i > max) {
            return -1;
        }
        int j = i - 1;
        int end = j + targetCount;
        int k = -1;
        while (j < end) {
            if (source.charAt(j++) == target[k++]) continue;
            ++i;
            break;
        }
        return i;
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isDate(CharSequence date, String pattern) {
        return Eval.isDate(date, pattern, Locale.getDefault());
    }

    public static boolean isDate(CharSequence date, String pattern, Locale locale) {
        if (date == null) {
            return false;
        }
        String sdate = date.toString();
        if (pattern.length() != sdate.length()) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, new DateFormatSymbols(locale));
        format.setLenient(false);
        try {
            format.parse(sdate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isDate(CharSequence date, String[] patterns) {
        return Eval.isDate(date, patterns, Locale.getDefault());
    }

    public static boolean isDate(CharSequence date, String[] patterns, Locale locale) {
        if (date == null) {
            return false;
        }
        String sdate = date.toString();
        SimpleDateFormat format = new SimpleDateFormat();
        format.setDateFormatSymbols(new DateFormatSymbols(locale));
        format.setLenient(false);
        int i = 0;
        while (i < patterns.length) {
            String ptrn = patterns[i];
            if (ptrn.length() == sdate.length()) {
                format.applyPattern(ptrn);
                try {
                    format.parse(sdate);
                    return true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isDecimal(CharSequence num, String pattern) {
        return Eval.isDecimal(num, pattern, Locale.getDefault());
    }

    public static boolean isDecimal(CharSequence num, String pattern, Locale locale) {
        if (num == null) {
            return false;
        }
        try {
            DecimalFormat format = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
            format.parse(num.toString());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isDecimal(CharSequence num, String[] patterns) {
        return Eval.isDecimal(num, patterns, Locale.getDefault());
    }

    public static boolean isDecimal(CharSequence num, String[] patterns, Locale locale) {
        if (num == null) {
            return false;
        }
        String snum = num.toString();
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        int i = 0;
        while (i < patterns.length) {
            try {
                format.applyPattern(patterns[i]);
                format.parse(snum);
                return true;
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        return false;
    }

    public static boolean isEncode(char c, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return Eval.isEncode(c, Charset.forName(charsetName));
    }

    public static boolean isEncode(char c, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(c);
    }

    public static boolean isEncode(CharSequence cs, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return Eval.isEncode(cs, Charset.forName(charsetName));
    }

    public static boolean isEncode(CharSequence cs, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(cs);
    }
}

