/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.group;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import shohaku.core.collections.Group;
import shohaku.core.collections.SetUtils;
import shohaku.core.collections.group.AbstractMapGroup;

public class HashSetGroup
extends AbstractMapGroup
implements Cloneable,
Serializable {
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_COLL_INITIAL_CAPACITY = 8;
    protected int initialCapacity;
    protected float loadFactor;
    protected int collInitialCapacity;

    public HashSetGroup() {
        this(16, 0.75f);
    }

    public HashSetGroup(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashSetGroup(Group group) {
        this(Math.max((int)((float)group.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(group);
    }

    public HashSetGroup(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 8);
    }

    public HashSetGroup(int initialCapacity, float loadFactor, int setInitialCapacity) {
        this(new HashMap(initialCapacity, loadFactor));
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.collInitialCapacity = setInitialCapacity;
    }

    protected HashSetGroup(Map groupMap) {
        super(groupMap);
    }

    protected Collection newEntryCollection() {
        return SetUtils.wrappedSet(new HashSet(this.collInitialCapacity));
    }

    public Object clone() {
        HashSetGroup result = new HashSetGroup(this.initialCapacity, this.loadFactor, this.collInitialCapacity);
        result.addAll(this);
        return result;
    }
}

