/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import shohaku.core.collections.KayValueIterator;
import shohaku.core.collections.KayValueIteratorUtils;

public class Parameters
implements Cloneable {
    public static final Parameters EMPTY_PARAMETERS = new Parameters();
    private final Entry[] table;
    private final Entry endEntry;
    private final int size;
    private final int hashCode;

    public Parameters() {
        this(new String[0]);
    }

    public Parameters(final String[] names) {
        this(new KayValueIterator(){
            private int _index = -1;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                if (this.hasNext()) {
                    ++this._index;
                } else {
                    throw new NoSuchElementException();
                }
                return this.getKey();
            }

            public boolean hasNext() {
                return this._index + 1 < names.length;
            }

            public Object getKey() {
                return names[this._index];
            }

            public Object getValue() {
                return null;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return names.length;
            }
        });
    }

    public Parameters(Object[] nameValue) {
        this(KayValueIteratorUtils.segmentKayValueIterator(nameValue));
    }

    public Parameters(List nameValue) {
        this(KayValueIteratorUtils.segmentKayValueIterator(nameValue));
    }

    public Parameters(Map prams) {
        this(KayValueIteratorUtils.asKayValueIterator(prams));
    }

    public Parameters(Parameters prams) {
        this(prams.kayValueIterator());
    }

    public Parameters(KayValueIterator i) {
        this.size = i.size();
        this.table = new Entry[Parameters.capacity(this.size)];
        Entry _entry = null;
        Entry _beginEntry = null;
        while (i.hasNext()) {
            i.next();
            String name = i.getKey().toString();
            Object value = i.getValue();
            int hashCode = Parameters.hash(name);
            int index = Parameters.indexFor(hashCode, this.table.length);
            Entry newEntry = new Entry(name, value);
            Entry oldEntry = this.putEntry(index, newEntry);
            if (oldEntry != null) {
                if (oldEntry == _entry) {
                    _entry = oldEntry.before;
                }
                if (oldEntry == _beginEntry) {
                    _beginEntry = oldEntry.after;
                }
            }
            if (_entry != null) {
                _entry.after = newEntry;
                newEntry.before = _entry;
            } else {
                _beginEntry = newEntry;
            }
            _entry = newEntry;
        }
        if (_entry != null) {
            this.endEntry = _entry;
            this.endEntry.after = _beginEntry;
            _beginEntry.before = this.endEntry;
        } else {
            this.endEntry = null;
        }
        this.hashCode = Parameters._hashCode(this);
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new ParametersIterator();
    }

    public KayValueIterator kayValueIterator() {
        return new ParametersKayValueIterator();
    }

    public boolean isEmpty() {
        return this.endEntry == null;
    }

    public String getName(int index) {
        return this.getEntry(index).getName();
    }

    public int getIndex(String name) {
        if (!this.isEmpty()) {
            Entry e = this.endEntry.after;
            int i = 0;
            while (i < this.size) {
                if (name.equals(e.getName())) {
                    return i;
                }
                e = e.after;
                ++i;
            }
        }
        return -1;
    }

    public Object getValue(String name) {
        Entry e = this.getEntry(name);
        if (e != null) {
            return e.getValue();
        }
        return null;
    }

    public Object getValue(String name, String defaultValue) {
        Entry e = this.getEntry(name);
        if (e != null) {
            return e.getValue();
        }
        return defaultValue;
    }

    public Object getValue(int index) {
        return this.getEntry(index).getValue();
    }

    public Object setValue(String name, Object value) {
        Entry e = this.getEntry(name);
        if (e != null) {
            return Parameters.swapValue(e, value);
        }
        return null;
    }

    public Object setValue(int index, Object value) {
        Entry e = this.getEntry(index);
        if (e != null) {
            return Parameters.swapValue(e, value);
        }
        return null;
    }

    public Entry getEntry(String name) {
        int hashCode = Parameters.hash(name);
        int index = Parameters.indexFor(hashCode, this.table.length);
        Entry e = this.table[index];
        while (e != null) {
            if (e.hashCode() == hashCode && name.equals(e.getName())) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Entry getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:" + this.size);
        }
        if (index < this.size >> 1) {
            Entry e = this.endEntry.after;
            int i = 0;
            while (i < index) {
                e = e.after;
                ++i;
            }
            return e;
        }
        Entry e = this.endEntry;
        int i = this.size - 1;
        while (i > index) {
            e = e.before;
            --i;
        }
        return e;
    }

    public boolean containsName(String name) {
        return -1 < this.getIndex(name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameters)) {
            return false;
        }
        Parameters p = (Parameters)o;
        if (this.size != p.size) {
            return false;
        }
        if (!this.isEmpty()) {
            Entry e = this.endEntry.after;
            Entry e2 = p.endEntry.after;
            int i = 0;
            while (i < this.size) {
                if (!e.equals(e2)) {
                    return false;
                }
                e = e.after;
                e2 = e2.after;
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Entry e = (Entry)i.next();
            buf.append(e.getName());
            buf.append('=');
            Object value = e.getValue();
            buf.append(value == this ? "(this Parameters)" : value);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public Object clone() {
        return new Parameters(this);
    }

    /*
     * Unable to fully structure code
     */
    private Entry putEntry(int index, Entry newEntry) {
        block4: {
            oldEntry = null;
            e = this.table[index];
            if (e != null) ** GOTO lbl17
            this.table[index] = newEntry;
            break block4;
lbl-1000:
            // 1 sources

            {
                if (Entry.access$4(e) == null) {
                    Entry.access$5(e, newEntry);
                    break;
                }
                if (Parameters.eq(Entry.access$4(e), newEntry)) {
                    oldEntry = Entry.access$4(e);
                    if (Entry.access$4(oldEntry) != null) {
                        Entry.access$5(newEntry, Entry.access$4(oldEntry));
                    }
                    Entry.access$5(e, newEntry);
                    this.removeLinkList(oldEntry);
                    break;
                }
                e = Entry.access$4(e);
lbl17:
                // 2 sources

                ** while (e != null)
            }
        }
        return oldEntry;
    }

    private void removeLinkList(Entry oldEntry) {
        if (oldEntry.after != null) {
            oldEntry.after.before = oldEntry.before;
        }
        if (oldEntry.before != null) {
            oldEntry.before.after = oldEntry.after;
        }
    }

    private static boolean eq(Entry entry, Entry entry2) {
        return entry.name.equals(entry2.name);
    }

    private static int capacity(int size) {
        return size * 2 + 1;
    }

    private static int indexFor(int hashCode, int length) {
        return hashCode & length - 1;
    }

    private static int hash(String name) {
        int h = name.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static Object swapValue(Entry entry, Object value) {
        Object old = entry.getValue();
        entry.setValue(value);
        return old;
    }

    private static int _hashCode(Parameters params) {
        int hashCode = 0;
        if (!params.isEmpty()) {
            Entry e = params.endEntry.after;
            int i = 0;
            while (i < params.size) {
                hashCode += e.hashCode();
                e = e.after;
                ++i;
            }
        }
        return hashCode;
    }

    private class ParametersIterator
    implements Iterator {
        private int _index = -1;
        private Entry e;

        ParametersIterator() {
            this.e = Parameters.this.endEntry;
        }

        public boolean hasNext() {
            return this.e != null && this._index + 1 < Parameters.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            this.e = this.e.after;
            return this.e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ParametersKayValueIterator
    implements KayValueIterator {
        private Entry e;
        private int _index;

        ParametersKayValueIterator() {
            this.e = Parameters.this.endEntry;
            this._index = -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.e != null && this._index + 1 < Parameters.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            this.e = this.e.after;
            return this.getKey();
        }

        public Object getKey() {
            this.check();
            return this.e.getName();
        }

        public Object getValue() {
            this.check();
            return this.e.getValue();
        }

        public Object setValue(Object value) {
            this.check();
            return this.e.setValue(value);
        }

        public int size() {
            return Parameters.this.size;
        }

        private void check() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.e == null) {
                throw new NoSuchElementException();
            }
        }
    }

    public static class Entry {
        private final String name;
        private Object value;
        private final int hashCode;
        private Entry next;
        private Entry before;
        private Entry after;

        public Entry(String name, Object value) {
            this.name = name;
            this.hashCode = Parameters.hash(name);
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = value;
            this.value = value;
            return oldValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.name.equals(e.name) && (this.value != null ? this.value.equals(e.value) : e.value == null);
        }

        public String toString() {
            return String.valueOf(this.name) + "=" + this.value;
        }

        static /* synthetic */ void access$5(Entry entry, Entry entry2) {
            entry.next = entry2;
        }
    }
}

