/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import shohaku.core.collections.wrapper.UnmodifiableListIterator;

public class ListIteratorUtils {
    public static final ListIterator EMPTY_LIST_ITERATOR = new ListIterator(){

        public int nextIndex() {
            return -1;
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return -1;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    };

    public static ListIterator unmodifiableListIterator(ListIterator listiterator) {
        return new UnmodifiableListIterator(listiterator);
    }

    public static ListIterator wrappedListIterator(ListIterator listiterator) {
        return new UnmodifiableListIterator(listiterator);
    }
}

