/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.KayValueIterator;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Eval;

public class KayValueIteratorUtils {
    public static KayValueIterator asKayValueIterator(Map map) {
        return new MapKayValueIterator(map);
    }

    public static KayValueIterator asKayValueIterator(Group group) {
        return new GroupKayValueIterator(group);
    }

    public static KayValueIterator indexKayValueIterator(List list) {
        return new ListKayValueIterator(list);
    }

    public static KayValueIterator indexKayValueIterator(Object[] a) {
        return new ArrayKayValueIterator(a);
    }

    public static KayValueIterator indexMappingKayValueIterator(List keys, List values) {
        return new IndexMappingListKayValueIterator(keys, values);
    }

    public static KayValueIterator indexMappingKayValueIterator(Object[] keys, Object[] values) {
        return new IndexMappingArrayKayValueIterator(keys, values);
    }

    public static KayValueIterator segmentKayValueIterator(List list) {
        return KayValueIteratorUtils.segmentKayValueIterator(list, 0, 2, 0, 1);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a) {
        return KayValueIteratorUtils.segmentKayValueIterator(a, 0, 2, 0, 1);
    }

    public static KayValueIterator segmentKayValueIterator(List list, int segment, int koffset, int valueOffset) {
        return KayValueIteratorUtils.segmentKayValueIterator(list, 0, segment, koffset, valueOffset);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a, int segment, int koffset, int valueOffset) {
        return KayValueIteratorUtils.segmentKayValueIterator(a, 0, segment, koffset, valueOffset);
    }

    public static KayValueIterator segmentKayValueIterator(List list, int start, int segment, int koffset, int voffset) {
        return new SegmentListKayValueIterator(list, start, segment, koffset, voffset);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a, int start, int segment, int koffset, int voffset) {
        return new SegmentArrayKayValueIterator(a, start, segment, koffset, voffset);
    }

    private static abstract class AbstractKayValueIterator
    implements KayValueIterator {
        AbstractKayValueIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MapKayValueIterator
    extends AbstractKayValueIterator {
        private final Iterator entrys;
        private final int size;
        private Map.Entry _entry = null;

        MapKayValueIterator(Map m) {
            Set entrySet = m.entrySet();
            this.entrys = entrySet.iterator();
            this.size = entrySet.size();
        }

        public boolean hasNext() {
            return this.entrys.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.entry().getKey();
        }

        public Object getValue() {
            return this.entry().getValue();
        }

        public Object setValue(Object value) {
            return this.entry().setValue(value);
        }

        public int size() {
            return this.size;
        }

        private Map.Entry entry() {
            if (this._entry == null) {
                throw new IllegalStateException();
            }
            return this._entry;
        }

        private void _next() {
            this._entry = (Map.Entry)this.entrys.next();
        }
    }

    private static class GroupKayValueIterator
    extends AbstractKayValueIterator {
        private final Iterator entrys;
        private final int size;
        private Group.Entry _entry = null;

        GroupKayValueIterator(Group g) {
            Set entrySet = g.entrySet();
            this.entrys = entrySet.iterator();
            this.size = entrySet.size();
        }

        public boolean hasNext() {
            return this.entrys.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.entry().getKey();
        }

        public Object getValue() {
            return this.entry().getValues();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.size;
        }

        private Group.Entry entry() {
            if (this._entry == null) {
                throw new IllegalStateException();
            }
            return this._entry;
        }

        private void _next() {
            this._entry = (Group.Entry)this.entrys.next();
        }
    }

    private static class ListKayValueIterator
    extends AbstractKayValueIterator {
        private final List list;
        private final int size;
        private int _index = -1;

        ListKayValueIterator(List list) {
            this.list = list;
            this.size = list.size();
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return Boxing.box(this.index());
        }

        public Object getValue() {
            return this.list.get(this.index());
        }

        public Object setValue(Object value) {
            return this.list.set(this.index(), value);
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.list.size() != this.size) {
                throw new ConcurrentModificationException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class ArrayKayValueIterator
    extends AbstractKayValueIterator {
        private final Object[] array;
        private final int size;
        private int _index = -1;

        ArrayKayValueIterator(Object[] a) {
            this.array = a;
            this.size = a.length;
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return Boxing.box(this.index());
        }

        public Object getValue() {
            return this.array[this.index()];
        }

        public Object setValue(Object value) {
            Object object = value;
            this.array[this.index()] = object;
            return object;
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class IndexMappingListKayValueIterator
    extends AbstractKayValueIterator {
        private final List keys;
        private final List values;
        private final int size;
        private int _index = -1;

        IndexMappingListKayValueIterator(List keys, List values) {
            if (keys == null || values == null) {
                throw new NullPointerException();
            }
            if (keys.size() == values.size()) {
                throw new IllegalArgumentException();
            }
            this.keys = keys;
            this.values = values;
            this.size = keys.size();
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.keys.get(this.index());
        }

        public Object getValue() {
            return this.values.get(this.index());
        }

        public Object setValue(Object value) {
            return this.values.set(this.index(), value);
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.keys.size() != this.size || this.values.size() != this.size) {
                throw new ConcurrentModificationException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class IndexMappingArrayKayValueIterator
    extends AbstractKayValueIterator {
        private final Object[] keys;
        private final Object[] values;
        private final int size;
        private int _index = -1;

        IndexMappingArrayKayValueIterator(Object[] keys, Object[] values) {
            if (keys == null || values == null) {
                throw new NullPointerException();
            }
            if (keys.length == values.length) {
                throw new IllegalArgumentException();
            }
            this.keys = keys;
            this.values = values;
            this.size = keys.length;
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.keys[this.index()];
        }

        public Object getValue() {
            return this.values[this.index()];
        }

        public Object setValue(Object value) {
            Object object = value;
            this.values[this.index()] = object;
            return object;
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class SegmentListKayValueIterator
    extends AbstractKayValueIterator {
        private final int size;
        private final int segment;
        private final int koffset;
        private final int voffset;
        private final int start;
        private final List list;
        private int _index = -1;

        SegmentListKayValueIterator(List list, int start, int segment, int koffset, int voffset) {
            if (list == null) {
                throw new NullPointerException();
            }
            int size = list.size();
            if (!(Eval.isRange(segment, 0, size) && Eval.isRange(koffset, 0, segment) && Eval.isRange(voffset, 0, segment) && Eval.isRange(start, 0, size - 1))) {
                throw new IllegalArgumentException("size:" + size + ", segment:" + segment + ", koffset:" + koffset + ", voffset:" + voffset + ", start:" + start);
            }
            this.size = (size - start) / segment;
            this.segment = segment;
            this.koffset = koffset;
            this.voffset = voffset;
            this.start = start;
            this.list = list;
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            return this.getKey();
        }

        public Object getKey() {
            return this.list.get(this.keyIndex());
        }

        public Object getValue() {
            return this.list.get(this.valueIndex());
        }

        public Object setValue(Object value) {
            return this.list.set(this.valueIndex(), value);
        }

        public int size() {
            return this.size;
        }

        private int keyIndex() {
            this.check();
            return this._index * this.segment + this.start + this.koffset;
        }

        private int valueIndex() {
            this.check();
            return this._index * this.segment + this.start + this.voffset;
        }

        private void check() {
            if (this._index < 0) {
                throw new IllegalStateException();
            }
            if (this.list.size() != this.size) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class SegmentArrayKayValueIterator
    extends AbstractKayValueIterator {
        private final int size;
        private final int segment;
        private final int koffset;
        private final int voffset;
        private final int start;
        private final Object[] array;
        private int _index = -1;

        SegmentArrayKayValueIterator(Object[] a, int start, int segment, int koffset, int voffset) {
            if (a == null) {
                throw new NullPointerException();
            }
            int size = a.length;
            if (!(Eval.isRange(segment, 0, size) && Eval.isRange(koffset, 0, segment) && Eval.isRange(voffset, 0, segment) && Eval.isRange(start, 0, size - 1))) {
                throw new IllegalArgumentException("size:" + size + ", segment:" + segment + ", koffset:" + koffset + ", voffset:" + voffset + ", start:" + start);
            }
            this.size = (size - start) / segment;
            this.segment = segment;
            this.koffset = koffset;
            this.voffset = voffset;
            this.start = start;
            this.array = a;
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            return this.getKey();
        }

        public Object getKey() {
            return this.array[this.keyIndex()];
        }

        public Object getValue() {
            return this.array[this.valueIndex()];
        }

        public Object setValue(Object value) {
            Object object = value;
            this.array[this.valueIndex()] = object;
            return object;
        }

        public int size() {
            return this.size;
        }

        private int keyIndex() {
            this.check();
            return this._index * this.segment + this.start + this.koffset;
        }

        private int valueIndex() {
            this.check();
            return this._index * this.segment + this.start + this.voffset;
        }

        private void check() {
            if (this._index < 0) {
                throw new IllegalStateException();
            }
        }
    }
}

