/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import shohaku.core.collections.Entry;

public class EntryUtils {
    public static Entry arrayEntry(byte[] a) {
        return new ByteArrayEntry(a);
    }

    public static Entry arrayEntry(short[] a) {
        return new ShortArrayEntry(a);
    }

    public static Entry arrayEntry(int[] a) {
        return new IntArrayEntry(a);
    }

    public static Entry arrayEntry(long[] a) {
        return new LongArrayEntry(a);
    }

    public static Entry arrayEntry(float[] a) {
        return new FloatArrayEntry(a);
    }

    public static Entry arrayEntry(double[] a) {
        return new DoubleArrayEntry(a);
    }

    public static Entry arrayEntry(boolean[] a) {
        return new BooleanArrayEntry(a);
    }

    public static Entry arrayEntry(Object[] a) {
        return new ObjectArrayEntry(a);
    }

    public static Entry identityArrayEntry(Object[] a) {
        return new IdentityObjectArrayEntry(a);
    }

    public static Entry identityEntry(Object a) {
        return new IdentityEntry(a);
    }

    static class IdentityEntry
    implements Entry {
        private final Object src;

        IdentityEntry(Object src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            return System.identityHashCode(this.src);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            return this.src == v;
        }
    }

    static class IdentityObjectArrayEntry
    implements Entry {
        private final Object[] src;

        IdentityObjectArrayEntry(Object[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += System.identityHashCode(this.src[i]);
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (this.src[i] != a[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class ObjectArrayEntry
    implements Entry {
        private final Object[] src;

        ObjectArrayEntry(Object[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += this.src[i] == null ? 0 : this.src[i].hashCode();
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (this.src[i] == null || a[i] == null ? this.src[i] != a[i] : !this.src[i].equals(a[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class ByteArrayEntry
    implements Entry {
        private final byte[] src;

        ByteArrayEntry(byte[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += this.src[i];
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof byte[])) {
                return false;
            }
            byte[] a = (byte[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class ShortArrayEntry
    implements Entry {
        private final short[] src;

        ShortArrayEntry(short[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += this.src[i];
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof short[])) {
                return false;
            }
            short[] a = (short[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class IntArrayEntry
    implements Entry {
        private final int[] src;

        IntArrayEntry(int[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += this.src[i];
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof int[])) {
                return false;
            }
            int[] a = (int[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class LongArrayEntry
    implements Entry {
        private final long[] src;

        LongArrayEntry(long[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += (int)(this.src[i] ^ this.src[i] >>> 32);
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof long[])) {
                return false;
            }
            long[] a = (long[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class FloatArrayEntry
    implements Entry {
        private final float[] src;

        FloatArrayEntry(float[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += Float.floatToIntBits(this.src[i]);
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof float[])) {
                return false;
            }
            float[] a = (float[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class DoubleArrayEntry
    implements Entry {
        private final double[] src;

        DoubleArrayEntry(double[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                long bits = Double.doubleToLongBits(this.src[i]);
                hash += (int)(bits ^ bits >>> 32);
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof double[])) {
                return false;
            }
            double[] a = (double[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class BooleanArrayEntry
    implements Entry {
        private final boolean[] src;

        BooleanArrayEntry(boolean[] src) {
            if (src == null) {
                throw new NullPointerException();
            }
            this.src = src;
        }

        public Object getValue() {
            return this.src;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.src.length) {
                hash += this.src[i] ? 1231 : 1237;
                ++i;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object v = e.getValue();
            if (this.src == v) {
                return true;
            }
            if (v == null || !(v instanceof boolean[])) {
                return false;
            }
            boolean[] a = (boolean[])v;
            if (this.src.length != a.length) {
                return false;
            }
            int i = 0;
            while (i < this.src.length) {
                if (a[i] != this.src[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

