/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.lang.reflect.Method;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.beans.MethodFeatureInfo;
import shohaku.core.beans.ParametersInfo;
import shohaku.core.lang.Boxing;
import shohaku.core.util.Format;

public final class MethodInfo
extends MethodFeatureInfo {
    public static final int METHOD = 0;
    public static final int SET_PROPERTY = 1;
    public static final int GET_PROPERTY = 2;
    public static final int CONSTRUCTOR = 3;
    private int type = 0;

    public MethodInfo() {
    }

    public MethodInfo(String methodName, ParametersInfo params, int type) {
        this.setMethodName(methodName);
        this.setParameteres(params);
        this.setType(type);
    }

    protected Object invokeMethod(Class c, Object obj) throws InvocationBeansException {
        if (c == null) {
            throw new NullPointerException("argument class is null.");
        }
        try {
            Method method = this.getMethod(c);
            return BeanUtilities.invokeMethod(c, obj, method, this.getParameterValues());
        }
        catch (NoSuchMethodException e) {
            throw new InvocationBeansException("Class#getMethod class:" + c, e);
        }
    }

    protected Method getMethod(Class c) throws NoSuchMethodException {
        Method method = null;
        switch (this.getType()) {
            case 0: {
                method = BeanUtilities.getMatchingAccessibleMethod(c, this.getMethodName(), this.getParameterTypes());
                break;
            }
            case 1: {
                method = BeanUtilities.getMatchingAccessibleSetProperty(c, this.getMethodName(), this.getParameterTypes());
                break;
            }
            case 2: {
                method = BeanUtilities.getMatchingAccessibleGetProperty(c, this.getMethodName(), this.getParameterTypes());
                break;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException(Format.format("type:{0}, class:{1}, method:{2}, args:{3,array}", new Object[]{Boxing.box(this.getType()), c, this.getMethodName(), this.getParameterTypes()}));
        }
        return method;
    }

    public boolean isConstructor() {
        return this.getType() == 3;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.checkUnmodifiable();
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException();
        }
        this.type = i;
    }
}

