/*
SRTabView.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/
/*
ChangeLog
2004.04.20 Hetima Computer <>
	*marge nightly 040419

2004.04.18 Hetima Computer <>
	*remember previous tab

2004.04.16-2 Hetima Computer <>
	*add "ignored key action"

2004.04.16 Hetima Computer <>
	*modified
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "Shiira.h"

@class HTSRTabBarView;

@interface SRTabView : NSView
{
    int                 _tabDefaultWidth;
    int                 _tabMinWidth;
    
    NSMutableArray*     _selectedItemsOrder;
   
    NSMutableArray*     _labels;
    BOOL                _isTabShownAlways;
    BOOL                _isTabShown;
    BOOL                _isSeparatorShown;
    
    id                  _delegate;
}

// Working with tab item
- (void)addItemWithLabel:(NSString*)label view:(NSView*)view;
- (void)addItemWithLabel:(NSString*)label view:(NSView*)view select:(BOOL)select;
- (void)removeItemAtIndex:(int)index;
- (void)selectItemAtIndex:(int)index;
- (int)selectedIndex;
- (void)removeAllItems;

- (NSTabView*)tabView;
- (NSView*)viewOfSelectedTabViewItem;
- (NSView*)viewAtIndex:(int)index;
- (int)indexOfView:(NSView*)view;

- (NSString*)labelAtIndex:(int)index;
- (void)setLabel:(NSString*)label atIndex:(int)index;

- (int)numberOfItems;

- (HTSRTabBarView*)tabBarView;

// Tab appearance
- (void)updateAppearance;
- (BOOL)isTabShown;
- (void)setTabShown:(BOOL)shown;
- (BOOL)isTabShownAlways;
- (void)setTabShownAlways:(BOOL)shown;
- (BOOL)isSeparatorShown;
- (void)setSeparatorShow:(BOOL)shown;
- (BOOL)isAccordingToStringWidth;
- (void)setAccordingToStringWidth:(BOOL)flag;

// Delegate
- (id)delegate;
- (void)setDelegate:(id)delegate;

@end

@interface SRTabViewItem : NSTabViewItem
{
	BOOL            _isLoading;
	HTSRTabBarView* _keeperView;
    
    id              _userInfo;
}
- (id)initWithIdentifier:(id)identifier;
- (BOOL)isLoading;
- (void)setIsLoading:(BOOL)flag;
- (void)setTabBarView:(HTSRTabBarView*)view;

- (id)userInfo;
- (void)setUserInfo:(id)userInfo;

@end

@interface NSObject (SRTabViewDelegate)
- (BOOL)srTabView:(SRTabView*)tabView 
        shouldSelectTabViewItem:(SRTabViewItem*)tabViewItem;
- (void)srTabView:(SRTabView*)tabView 
        willSelectTabViewItem:(SRTabViewItem*)tabViewItem;
- (void)srTabView:(SRTabView*)tabView 
        didSelectTabViewItem:(SRTabViewItem*)tabViewItem;
- (void)srTabViewDidChangeNumberOfTabViewItems:(SRTabView*)tabView;
@end
