/*
SRDragImageView.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRBookmarkImageView.h"

@implementation SRBookmarkImageView

#pragma mark -
//--------------------------------------------------------------//
// Bookmark
//--------------------------------------------------------------//

- (SRBookmark*)bookmark
{
    return _bookmark;
}

- (void)setBookmark:(SRBookmark*)bookmark
{
    if (bookmark != _bookmark) {
        [_bookmark release];
        _bookmark = [bookmark retain];
    }
}

#pragma mark -
//--------------------------------------------------------------//
// Drag and drop
//--------------------------------------------------------------//

- (void)mouseDown:(NSEvent*)event
{
    // Do nothing here, but it is needed for mouseDragged: method
}

- (void)mouseDragged:(NSEvent*)event
{
    // Check bookmark
    if (!_bookmark) {
        [super mouseDragged:event];
        return;
    }
    
    // Create pasteboard
    NSPasteboard*   pboard;
    pboard = [NSPasteboard pasteboardWithName:NSDragPboard];
    
    // Write bookmarks to pasteboard
    SRWriteBookmarksToPasteboard([NSArray arrayWithObject:_bookmark], pboard);
    
    // Create dragging image
    NSImage*    draggingImage;
    draggingImage = [_bookmark draggingImage];
    
    // Start dragging
    NSPoint startAt;
#if 1
    startAt = NSZeroPoint;
#else
    NSRect  frame;
    frame = [self frame];
    startAt = frame.origin;
    if ([self isFlipped]) {
        startAt.y = frame.size.height - startAt.y;
    }
#endif
    
    [self dragImage:draggingImage 
            at:startAt 
            offset:NSZeroSize 
            event:event 
            pasteboard:pboard 
            source:self 
            slideBack:YES];
}

- (unsigned int)draggingSourceOperationMaskForLocal:(BOOL)isLocal
{
    return NSDragOperationGeneric;
}

@end
