/*
SRAnimation.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "Shiira.h"

typedef enum {
    SRAnimationLinear, 
} SRAnimationCurve;

typedef float   SRAnimationProgress;

@interface SRAnimation : NSObject
{
    NSTimeInterval      _duration;
    SRAnimationProgress _currentProgress;
    float               _frameRate;
    id                  _delegate;
    NSTimer*            _timer;
    NSTimeInterval      _startTime;
    
    NSMutableArray*     _progressMarks;
    int                 _nextProgressMarkIndex;
    
    SRAnimationCurve    _animationCurve;
}

// Initialize
- (id)initWithDuration:(NSTimeInterval)duration animationCurve:(SRAnimationCurve)animationCurve;

// Configure
- (id)delegate;
- (void)setDelegate:(id)delegate;
- (NSTimeInterval)duration;
- (void)setDuration:(NSTimeInterval)duration;
- (float)frameRate;
- (void)setFrameRate:(float)frameRate;

// Controlling and monitoring
- (void)startAnimation;
- (void)stopAnimation;
- (BOOL)isAnimating;
- (SRAnimationProgress)currentProgress;
- (void)setCurrentProgress:(SRAnimationProgress)progress;
- (float)currentValue;

// Managing progress marks
- (NSArray*)progressMarks;
- (void)setProgressMarks:(NSArray*)progressMarks;

@end

@interface NSObject (SRAnimationDelegate)
- (void)animation:(SRAnimation*)animation didReachProgressMark:(SRAnimationProgress)progress;
- (void)animationDidEnd:(SRAnimation*)animation;
- (void)animationDidStop:(SRAnimation*)animation;
@end
