/*
NSDictionaryEx.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "NSDictionaryEx.h"

@implementation NSMutableDictionary (DeepCopy)

- (id)initWithDictionary:(NSDictionary*)otherDict copyItemsDeeply:(BOOL)flag
{
    if (!flag) {
        return [self initWithDictionary:otherDict];
    }
    
    // Create mutable dictionary
    self = [self initWithDictionary:otherDict copyItems:flag];
    if (!self) {
        return nil;
    }
    
    // Check object class
    NSEnumerator*   enumerator;
    id              key;
    enumerator = [self keyEnumerator];
    while (key = [enumerator nextObject]) {
        id  object;
        object = [self objectForKey:key];
        
        // For array
        if ([object isKindOfClass:[NSArray class]]) {
            // Copy deeply
            object = [[NSMutableArray alloc] initWithArray:object copyItemsDeeply:flag];
            [self setObject:object forKey:key];
            
            continue;
        }
        // For dictionary
        if ([object isKindOfClass:[NSDictionary class]]) {
            // Copy deeply
            object = [[NSMutableDictionary alloc] initWithDictionary:object copyItemsDeeply:flag];
            [self setObject:object forKey:key];
            
            continue;
        }
    }
    
    return self;
}

@end
