/*
COPYRIGHT AND PERMISSION NOTICE 

Copyright © 2003 Karelia Software, LLC. All rights reserved. 

Permission to use, copy, modify, and distribute this software for any purpose with 
or without fee is hereby granted, provided that the above copyright notice and this 
permission notice appear in all copies. 

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE AUTHORS OR 
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 

Except as contained in this notice, the name of a copyright holder shall not be used 
in advertising or otherwise to promote the sale, use or other dealings in this Software 
without prior written authorization of the copyright holder
*/

#import "NSAttributedStringEx.h"

@implementation NSAttributedString (Truncate)

- (NSAttributedString*)truncateForWidth:(int)inWidth
{
    static NSString*    _horizontalEllipsis = nil;
    if (!_horizontalEllipsis) {
        unichar uni[1];
        uni[0] = 0x2026;
        _horizontalEllipsis = [[NSString stringWithCharacters:uni length:1] retain];
    }
    
    NSAttributedString *result = self;
    if ([self size].width > inWidth) {
        NSMutableAttributedString *newString;
        newString = [[NSMutableAttributedString alloc] initWithAttributedString:self];
        [newString autorelease];
        
        int curLength = [self length] - 1; // start by chopping off at least one
        
        while ([newString size].width > inWidth) {
            NSRange range;
            range = NSMakeRange(curLength - 1, 2); // replace 2 characters with …
            [newString replaceCharactersInRange:range withString:_horizontalEllipsis];
            curLength--;
        }
        result = newString;
    }
    return result;
}

@end

@implementation NSAttributedString (Attachement)

- (void)_removeAttachmentFrom:(NSMutableAttributedString*)attrStr
{
    // Get range of attacment
    id      attr;
    NSRange range;
    attr = [attrStr attribute:NSAttachmentAttributeName 
            atIndex:0 
            effectiveRange:&range];
    if (range.length <= 0) {
        return;
    }
    
    // Get range again
    if (!attr) {
        attr = [attrStr attribute:NSAttachmentAttributeName 
                atIndex:range.location 
                effectiveRange:&range];
        if (range.length <= 0 || !attr) {
            return;
        }
    }
    
    // Delete attachment
    [attrStr deleteCharactersInRange:range];
}

- (NSString*)stringWithoutAttachment
{
    NSMutableAttributedString*  attrStr;
    attrStr = [[NSMutableAttributedString alloc] initWithAttributedString:self];
    
    while ([attrStr containsAttachments]) {
        [self _removeAttachmentFrom:attrStr];
    }
    
    return [attrStr string];
}

@end
