<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================= //
	// upgrade.php - 0.5 //
	// ================= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// Show all errors but no warnings
	error_reporting(E_ALL & ~E_NOTICE);

	// check if MGB has been already installed
	if (file_exists("../includes/config.inc.php"))
		{
		require ("../includes/config.inc.php");
		if(!isset($mgb_installation_complete))
			{
			echo "It seems as if you haven't installed the MGB yet. You can do that <a href=\"install.php\">here</a>.<br>br>If MGB is already installed, try copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.";
			die();
			}
		}
	elseif (file_exists("../config.inc.php"))
		{
		if (copy("../config.inc.php", "../includes/config.inc.php"))
			{
			require ("../includes/config.inc.php");
			if(!isset($mgb_installation_complete))
				{
				echo "It seems as if you haven't installed the MGB yet. You can do that <a href=\"install.php\">here</a>.";
				die();
				}
			}
		else
			{
			echo "Due to changes of the directory structure since MGB 0.6.4 it is necessary that ''config.inc.php'' lies in the folder ''[root]/includes''.<br /><br />upgrade.php tried to copy it for you in that directory, but that failed. Please copy the file manually and start upgrade.php again.";
			}
		}
	else
		{
		echo "The config file could not be found. If you haven't installed the MGB yet, you can do that <a href=\"install.php\">here</a>.";	
		die();
		}

	// load includes
	require ("../includes/config.inc.php");
	require ("includes/config.inc.php");
	require ("includes/functions.inc.php");
	require ("includes/load_settings.inc.php");

	echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n";
	echo "\t\t\"http://www.w3.org/TR/html4/loose.dtd\">\n";
	echo "<html>\n";
	echo "<head>\n";
	echo "<title>MGB OpenSource Guestbook - upgrade.php</title>\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<table summary=\"upgrade\">\n";
	echo "\t<tr>\n";
	echo "\t\t<td><span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px;\">New version:</span></td>\n";
	if($settings['version'] == "0.6.4")
		{
		echo "\t\t<td><span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">0.6.5</span></td>\n";
		}
	else
		{
		echo "\t\t<td><span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">".MGB_VERSION."</span></td>\n";
		}
	echo "\t</tr>\n";
	echo "\t<tr>\n";
	echo "\t\t<td><span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px;\">Installed version:</span></td>\n";
	echo "\t\t<td><span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">".$settings['version']."</span></td>\n";
	echo "\t</tr>\n";
	echo "</table>\n<br>\n";

	switch(version_compare($settings['version'], MGB_VERSION))
		{
		case -1: $update_necessary = 1;
			break;
		case 0: $update_necessary = 0;
			break;
		case 1: $update_necessary = 0;
			break;
		}

	// Override version compare if 0.6.4 is installed. There was a mistake in writing data into config.inc.php.
	// A constant with the version number was added. That was not good, because it overrides the new version number
	// of upgrade.php.
	if($settings['version'] == "0.6.4")
		{
		$update_necessary = 1;
		}

	// update database
	if(!isset($success)) { $success = 0; }

	if(isset($update_necessary) AND $update_necessary == 1)
		{
		if($settings['version'] == "0.6.4")
			{
			include "upgrade/064.php";
			}
		elseif($settings['version'] == "0.6.3")
			{
			include "upgrade/063.php";
			}
		elseif($settings['version'] == "0.6.2")
			{
			include "upgrade/062.php";
			}
		elseif($settings['version'] == "0.6.1")
			{
			include "upgrade/061.php";
			}
		elseif($settings['version'] == "0.6")
			{
			include "upgrade/06.php";
			}

	for($i = 1; $i <= $to; $i++)
			{
			$sqlcommand = $sql[$i];
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(upgrade.php, Line 95) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(upgrade.php, Line 96) Error: ".mysql_error());
			if(@mysql_query($sqlcommand, $link) == TRUE)
				{
				echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">".$sqldescription[$i]."</span>\n
					\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
				$success++;
				$count++;
				}
			else
				{
				echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">".$sqldescription[$i]."</span>\n
					\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n
					\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">Errormessage: ".mysql_error()."<br /><br /></span>\n";
				$count++;
				}
			}

		if ($count == $success)
			{
			echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\"><br />No Errors! Your Database has been updated successfully! :)</span>\n";
			}
		else
			{
			echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: maroon;\"><br />Some Errors have occured. It could be possible that you have some duplicate sql entries or something, and the MGB may although work properly.<br /></span>\n";
			}
		}
	else
		{
		echo "<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: midnightblue;\">Update is not necessary. Newest version is already installed.</span>"; 
		}
	echo "</body>\n";
	echo "</html>\n";
?>
