<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ===================== //
	// version.inc.php - 1.0 //
	// ===================== //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// make sure nobody has direct acces to this script
	if (!defined('ADMINISTRATION'))
		{
		include ("error.html");
		die();
		}
	else
		{
		if(check_rights($_GET['action'], $_SESSION['ID']))
			{
			// load config, settings, template and language files
			require ("../includes/config.inc.php");
			require ("../includes/load_settings.inc.php");
			require("../language/".$settings['language_path']."/lang_admin.php");
			require ("load_template_admin.inc.php");
			require ("../includes/functions.inc.php");

			// latest stable version
			if( !function_exists("fopen"))
				{
				$file = fopen("http://www.m-gb.org/latest.txt", "r");
				$latest_version = fread($file, 50);
				fclose($file);

				// latest unstable version
				$file = fopen("http://www.m-gb.org/latest_dev.txt", "r");
				$latest_devversion = fread($file, 50);
				fclose($file);

				/* $latest_version = file_get_contents('http://www.m-gb.org/latest.txt'); */

				switch(version_compare($settings['version'], $latest_version)) {
					case -1: $version_info = "<span class='old_version'>".$lang['old_version']."</span>";
						break;
					case 0: $version_info = "<span class='same_version'>".$lang['same_version']."</span>";
						break;
					case 1: $version_info = "<span class='newer_version'>".$lang['newer_version']."</span>";
						break;
					}
				}
			else
				{
				$latest_version = "?";
				$latest_devversion = "?";
				$version_info = "<span class='old_version'>".$lang['errormessage15']."</span>";
				}
			}
		}

	$page_include = $content_version;
	$page_include = preg_replace("/\{LANG_CURRENT_VERSION\}/", $lang['current_version'], $page_include);
	$page_include = preg_replace("/\{LANG_STABLE_VERSION\}/", $lang['stable_version'], $page_include);
	$page_include = preg_replace("/\{LANG_UNSTABLE_VERSION\}/", $lang['unstable_version'], $page_include);
	
	$page_include = preg_replace("/\{LATEST_VERSION\}/", $latest_version, $page_include);
	$page_include = preg_replace("/\{LATEST_DEVVERSION\}/", $latest_devversion, $page_include);
	$page_include = preg_replace("/\{VERSION_INFO\}/", $version_info, $page_include);
	$content_scrolling_function = "<br />";
?>
